/* KinokoBufferStream.hh */
/* Created by Enomoto Sanshiro on 23 February 1998. */
/* Last updated by Enomoto Sanshiro on 17 April 2001. */


#ifndef __KinokoBufferStream_hh__
#define __KinokoBufferStream_hh__


#include "KinokoBufferClient.hh"
#include "KinokoStream.hh"



class TKinokoInputBufferStream: public TKinokoInputStream {
  public:
    TKinokoInputBufferStream(TKinokoBufferReader *BufferReader);
    virtual ~TKinokoInputBufferStream();
    virtual void Destroy(void);
    virtual bool HasData(void);
    virtual size_t NextDataSize(void);
    virtual int Read(void *Address, size_t MaxSize) throw(TKinokoException);
    virtual int NextEntry(void *&Address) throw(TKinokoException);
    virtual void Flush(void* Address) throw(TKinokoException);
    virtual int GetEntry(void *&Address) throw(TKinokoException);
    virtual void ReleaseEntry(void* Address) throw(TKinokoException);
  protected:
    TKinokoBufferReader *_BufferReader;
};


class TKinokoOutputBufferStream: public TKinokoOutputStream {
  public:
    TKinokoOutputBufferStream(TKinokoBufferWriter *BufferWriter);
    virtual ~TKinokoOutputBufferStream();
    virtual void Destroy(void);
    virtual int Write(void *Address, size_t Size) throw(TKinokoException);
    virtual int NextEntry(void *&Address, size_t MaxSize) throw(TKinokoException);
    virtual int Flush(void* Address, size_t Size) throw(TKinokoException);
    virtual int GetEntry(void *&Address, size_t MaxSize) throw(TKinokoException);
    virtual int ReleaseEntry(void* Address, size_t Size) throw(TKinokoException);
  protected:
    TKinokoBufferWriter *_BufferWriter;
};


#endif
