/* KinokoFileStream.hh */
/* Created by Enomoto Sanshiro on 23 February 1998. */
/* Last updated by Enomoto Sanshiro on 21 February 2002. */


#ifndef __KinokoFileStream_hh__
#define __KinokoFileStream_hh__


#include "MushFramedFile.hh"
#include "KinokoStream.hh"



class TKinokoInputFileStream: public TKinokoInputStream {
  public:
    TKinokoInputFileStream(TMushFramedFile *File, int LocalBufferSize = 1024*1024, int LocalBufferEntryTableSize = 4096);
    virtual ~TKinokoInputFileStream();
    virtual void Destroy(void);
    virtual bool HasData(void);
    virtual size_t NextDataSize(void);
    virtual int Read(void *Address, size_t MaxSize) throw(TKinokoException);
    virtual int NextEntry(void *&Address) throw(TKinokoException);
    virtual void Flush(void* Address) throw(TKinokoException);
    virtual int GetEntry(void *&Address) throw(TKinokoException);
    virtual void ReleaseEntry(void* Address) throw(TKinokoException);
  public:
    virtual long NumberOfPackets(void) throw(TKinokoException);
    virtual long PacketCount(void) throw(TKinokoException);
    virtual void JumpTo(long PacketIndex) throw(TKinokoException);
  protected:
    TMushFramedFile *_File;
};


class TKinokoOutputFileStream: public TKinokoOutputStream {
  public:
    TKinokoOutputFileStream(TMushFramedFile *File, int LocalBufferSize = 1024*1024, int LocalBufferEntryTableSize = 4096);
    virtual ~TKinokoOutputFileStream();
    virtual void Destroy(void);
    virtual int Write(void *Address, size_t Size) throw(TKinokoException);
    virtual int NextEntry(void *&Address, size_t MaxSize) throw(TKinokoException);
    virtual int Flush(void* Address, size_t Size) throw(TKinokoException);
    virtual int GetEntry(void *&Address, size_t MaxSize) throw(TKinokoException);
    virtual int ReleaseEntry(void* Address, size_t Size) throw(TKinokoException);
  protected:
    TMushFramedFile *_File;
};


#endif
