/* KinokoNullStream.cc */
/* Created by Enomoto Sanshiro on 9 January 2001. */
/* Last updated by Enomoto Sanshiro on 17 April 2001. */


#include "KinokoStream.hh"
#include "KinokoNullStream.hh"

using namespace std;



TKinokoInputNullStream::TKinokoInputNullStream(void)
: TKinokoInputStream(0, 0)
{
}

TKinokoInputNullStream::~TKinokoInputNullStream() 
{
}

void TKinokoInputNullStream::Destroy(void)
{
}

bool TKinokoInputNullStream::HasData(void)
{
    return true;
}

size_t TKinokoInputNullStream::NextDataSize(void)
{
    return 0;
}

int TKinokoInputNullStream::Read(void *Address, size_t MaxSize) throw(TKinokoException)
{
    return 0;
}

int TKinokoInputNullStream::NextEntry(void *&Address) throw(TKinokoException)
{
    return GetEntry(Address);
}

void TKinokoInputNullStream::Flush(void* Address) throw(TKinokoException)
{
    ReleaseEntry(Address);
}

int TKinokoInputNullStream::GetEntry(void *&Address) throw(TKinokoException)
{
    Address = _WorkArea;
    return 0;
}

void TKinokoInputNullStream::ReleaseEntry(void* Address) throw(TKinokoException)
{
}



TKinokoOutputNullStream::TKinokoOutputNullStream(void)
: TKinokoOutputStream(0, 0)
{
}

TKinokoOutputNullStream::~TKinokoOutputNullStream() 
{
}

void TKinokoOutputNullStream::Destroy(void)
{
}

int TKinokoOutputNullStream::Write(void *Address, size_t Size) throw(TKinokoException)
{
    return Size;
}

int TKinokoOutputNullStream::NextEntry(void *&Address, size_t MaxSize) throw(TKinokoException)
{
    return GetEntry(Address, MaxSize);
}

int TKinokoOutputNullStream::Flush(void* Address, size_t Size) throw(TKinokoException)
{
    return ReleaseEntry(Address, Size);
}

int TKinokoOutputNullStream::GetEntry(void *&Address, size_t MaxSize) throw(TKinokoException)
{
    if (MaxSize > _WorkAreaSize) {
	delete[] _WorkArea;
	_WorkAreaSize = (unsigned) (1.5 * MaxSize);
	_WorkArea = new unsigned[_WorkAreaSize];
    }
    Address = _WorkArea;

    return MaxSize;
}

int TKinokoOutputNullStream::ReleaseEntry(void* Address, size_t Size) throw(TKinokoException)
{
    return Size;
}
