/* KinokoHistogram2dView.hh */
/* Created by Enomoto Sanshiro on 13 January 2001. */
/* Last updated by Enomoto Sanshiro on 13 January 2001. */


#ifndef __KinokoHistogram2dView_hh__
#define __KinokoHistogram2dView_hh__


#include <string>
#include <iostream>
#include "KameHistogram2d.hh"
#include "KameRepository.hh"
#include "KinokoView.hh"


class TKinokoHistogram2dView: public TKinokoView {
  public:
    TKinokoHistogram2dView(kame::TKameHistogram2d* Histogram);
    virtual ~TKinokoHistogram2dView();
    virtual void SetAxisTitle(const std::string& XTitle, const std::string& YTitle);
    virtual void DisableZScale(void);
    virtual void SetZScaleLog(void);
    virtual void SetZScaleLinear(void);
  protected:
    virtual bool SetDrawOption(const std::string& OptionString);
    virtual void SaveThis(kame::TKameRepository* Repository) throw(TKinokoException);
    virtual void ClearThis(void);
  protected:
    kame::TKameHistogram2d* _Histogram;
    float _XMin, _XMax, _NumberOfXBins, _XBinStep;
    float _YMin, _YMax, _NumberOfYBins, _YBinStep;
    float _ZMin, _ZMax;
    std::string _XTitle, _YTitle;
    int _PlotType;
    bool _IsZScaleEnabled;
    bool _IsZScaleLog;
  public:
    enum THistogram2dPlotType {
	PlotType_Scatter,
	PlotType_Box,
	PlotType_Color,
	PlotType_Gray,
	_NumberOfHistogramTypes
    };
};



class TKinokoKoapHistogram2dView: public TKinokoHistogram2dView {
  public:
    TKinokoKoapHistogram2dView(kame::TKameHistogram2d* Histogram, std::ostream* OutputStream);
    virtual ~TKinokoKoapHistogram2dView();
  protected:
    virtual void DeployThis(void);
    virtual void DrawThis(void);
    virtual void ClearThis(void);
  protected:
    std::ostream* _OutputStream;
};


#endif
