/* KinokoSchematicView.hh */
/* Created by Enomoto Sanshiro on 5 October 2008. */
/* Last updated by Enomoto Sanshiro on 5 October 2008. */


#ifndef __KinokoSchematicView_hh__
#define __KinokoSchematicView_hh__


#include <iostream>
#include <string>
#include <map>
#include "KameNtuple.hh"
#include "KameRepository.hh"
#include "KinokoView.hh"


class TKinokoSchematicView: public TKinokoView {
  public:
    TKinokoSchematicView(kame::TKameNtuple* Ntuple, float XMin, float XMax, float YMin, float YMax);
    virtual ~TKinokoSchematicView();
    virtual int SetColorScale(float Min, float Max, const std::string& Type) = 0;
    virtual int PutTextItem(int Address, float X0, float Y0, const std::string& Format) = 0;
    virtual int PutRectangleItem(int Address, float X0, float Y0, float X1, float Y1) = 0;
    virtual int PutCircleItem(int Address, float X0, float Y0, float Radius) = 0;
  protected:
    virtual void SaveThis(kame::TKameRepository* Repository) throw(TKinokoException);
    virtual void ClearThis(void);
  protected:
    kame::TKameNtuple* _Ntuple;
    float _XMin, _XMax, _YMin, _YMax;
};



class TKinokoKoapSchematicView: public TKinokoSchematicView {
  public:
    TKinokoKoapSchematicView(kame::TKameNtuple* Ntuple, float XMin, float XMax, float YMin, float YMax, std::ostream* OutputStream);
    virtual ~TKinokoKoapSchematicView();
    virtual int SetColorScale(float Min, float Max, const std::string& Type);
    virtual int PutTextItem(int Address, float X0, float Y0, const std::string& Format);
    virtual int PutRectangleItem(int Address, float X0, float Y0, float X1, float Y1);
    virtual int PutCircleItem(int Address, float X0, float Y0, float Radius);
  protected:
    virtual void DeployThis(void);
    virtual void DrawThis(void);
    virtual void ClearThis(void);
  protected:
    std::ostream* _OutputStream;
    std::multimap<int, int> _ItemIdTable;
    std::vector<std::string> _ScaleDeclarationList;
    std::vector<std::string> _ItemDeclarationList;
    int _CurrentColorScaleId;
};


#endif
