/* KinokoView.cc */
/* Created by Enomoto Sanshiro on 4 November 2000. */
/* Last updated by Enomoto Sanshiro on 15 June 2002. */


#include <string>
#include <sstream>
#include <vector>
#include "KameRepository.hh"
#include "KinokoViewTrimming.hh"
#include "KinokoView.hh"

using namespace std;
using namespace kame;


int TKinokoView::_ViewCount = 0;


TKinokoView::TKinokoView(void)
{
    _ParentView = 0;

    _Left = 0;
    _Top = 0;
    _Width = 0;
    _Height = 0;

    _PageNumber = 0;

    ostringstream NameStream;
    NameStream << "view#" << _ViewCount++;
    _Name = NameStream.str();
}

TKinokoView::~TKinokoView()
{
    for (unsigned i = 0; i < _TrimmingList.size(); i++) {
	delete _TrimmingList[i];
    }
}

void TKinokoView::SetName(const string& Name)
{
    _Name = Name;
}

void TKinokoView::SetParent(TKinokoView* ParentView)
{
    _ParentView = ParentView;
}

void TKinokoView::SetPosition(float Left, float Top, float Width, float Height)
{
    _Left = Left;
    _Top = Top;
    _Width = Width;
    _Height = Height;
}

void TKinokoView::SetPage(int PageNumber)
{
    _PageNumber = PageNumber;
}

void TKinokoView::AddViewTrimming(TKinokoViewTrimming* Trimming)
{
    _TrimmingList.push_back(Trimming);
}

const string& TKinokoView::Name(void) const
{
    return _Name;
}

TKinokoView* TKinokoView::Parent(void)
{
    return _ParentView;
}

float TKinokoView::Left(void) const
{
    return _Left;
}

float TKinokoView::Top(void) const
{
    return _Top;
}

float TKinokoView::Width(void) const
{
    return _Width;
}

float TKinokoView::Height(void) const
{
    return _Height;
}

void TKinokoView::Deploy(void)
{
    DeployThis();
}

void TKinokoView::Draw(void)
{
    DrawThis();

    for (unsigned i = 0; i < _TrimmingList.size(); i++) {
	_TrimmingList[i]->Draw();
    }
}

void TKinokoView::Clear(void)
{
    ClearThis();
}

void TKinokoView::Save(TKameRepository* Repository) throw(TKinokoException)
{
    SaveThis(Repository);
}

bool TKinokoView::SetDrawOption(const std::string& OptionString)
{
    return false;
}
