/* KinokoViewAction.hh */
/* Created by Enomoto Sanshiro on 16 June 2002. */
/* Last updated by Enomoto Sanshiro on 29 September 2002. */


#ifndef __KinokoViewAction_hh__
#define __KinokoViewAction_hh__


#include <string>
#include <vector>
#include <map>
#include "KinokoPlatform.hh"
#include "KinokoView.hh"
#include "KameRepository.hh"
#include "KinokoTrendView.hh"
#include "KinokoHistoryView.hh"


class TKinokoViewAction {
  public:
    TKinokoViewAction(void);
    virtual ~TKinokoViewAction(void);
    virtual void Execute(void) = 0;
    virtual void Dump(std::ostream& os, const std::string& Indent) = 0;
};


class TKinokoViewDrawAction: public TKinokoViewAction {
  public:    
    TKinokoViewDrawAction(TKinokoView* View);
    virtual ~TKinokoViewDrawAction();
    virtual void Execute(void) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent);
  protected:
    TKinokoView* _View;
};


class TKinokoViewClearAction: public TKinokoViewAction {
  public:    
    TKinokoViewClearAction(TKinokoView* View);
    virtual ~TKinokoViewClearAction();
    virtual void Execute(void) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent);
  protected:
    TKinokoView* _View;
};


class TKinokoViewSaveAction: public TKinokoViewAction {
  public:    
    TKinokoViewSaveAction(TKinokoView* View, kame::TKameRepository* Repository);
    virtual ~TKinokoViewSaveAction();
    virtual void Execute(void) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent);
  protected:
    TKinokoView* _View;
    kame::TKameRepository* _Repository;
};


class TKinokoTrendViewDrawAction: public TKinokoViewDrawAction {
  public:    
    TKinokoTrendViewDrawAction(TKinokoTrendView* Trend, int FieldId);
    virtual ~TKinokoTrendViewDrawAction();
    virtual void Execute(void) throw(TKinokoException);
  protected:
    TKinokoTrendView* _TrendView;
    int _FieldId;
};


class TKinokoTrendViewSetOperationRangeAction: public TKinokoViewAction {
  public:
    TKinokoTrendViewSetOperationRangeAction(TKinokoTrendView* TrendView, double LowerBound, double UpperBound, int NumberOfPointsToJudge);
    virtual ~TKinokoTrendViewSetOperationRangeAction();
    virtual void Execute(void) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent);
  protected:
    TKinokoTrendView* _TrendView;
    double _LowerBound, _UpperBound;
    int _NumberOfPointsToJudge;
};


class TKinokoTrendViewEnableAlarmAction: public TKinokoViewAction {
  public:
    TKinokoTrendViewEnableAlarmAction(TKinokoTrendView* TrendView, TKinokoEventEmitter* EventEmitter, const std::string& Message);
    virtual ~TKinokoTrendViewEnableAlarmAction();
    virtual void Execute(void) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent);
  protected:
    TKinokoTrendView* _TrendView;
    TKinokoEventEmitter* _EventEmitter;
    std::string _Message;
};


class TKinokoTrendViewDisableAlarmAction: public TKinokoViewAction {
  public:
    TKinokoTrendViewDisableAlarmAction(TKinokoTrendView* TrendView);
    virtual ~TKinokoTrendViewDisableAlarmAction();
    virtual void Execute(void) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent);
  protected:
    TKinokoTrendView* _TrendView;
};



class TKinokoHistoryViewDrawAction: public TKinokoViewDrawAction {
  public:    
    TKinokoHistoryViewDrawAction(TKinokoHistoryView* View, int FieldId);
    virtual ~TKinokoHistoryViewDrawAction();
    virtual void Execute(void) throw(TKinokoException);
  protected:
    TKinokoHistoryView* _HistoryView;
    int _FieldId;
};

class TKinokoHistoryViewHoldAction: public TKinokoViewAction {
  public:
    TKinokoHistoryViewHoldAction(TKinokoHistoryView* HistoryView, kame::TKameHistory* History);
    virtual ~TKinokoHistoryViewHoldAction();
    virtual void Execute(void) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent);
  protected:
    TKinokoHistoryView* _HistoryView;
    kame::TKameHistory* _History;
};


class TKinokoHistoryViewSetOperationRangeAction: public TKinokoViewAction {
  public:
    TKinokoHistoryViewSetOperationRangeAction(TKinokoHistoryView* HistoryView, double LowerBound, double UpperBound);
    virtual ~TKinokoHistoryViewSetOperationRangeAction();
    virtual void Execute(void) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent);
  protected:
    TKinokoHistoryView* _HistoryView;
    double _LowerBound, _UpperBound;
};


class TKinokoHistoryViewEnableAlarmAction: public TKinokoViewAction {
  public:
    TKinokoHistoryViewEnableAlarmAction(TKinokoHistoryView* HistoryView, TKinokoEventEmitter* EventEmitter, const std::string& Message);
    virtual ~TKinokoHistoryViewEnableAlarmAction();
    virtual void Execute(void) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent);
  protected:
    TKinokoHistoryView* _HistoryView;
    TKinokoEventEmitter* _EventEmitter;
    std::string _Message;
};


class TKinokoHistoryViewDisableAlarmAction: public TKinokoViewAction {
  public:
    TKinokoHistoryViewDisableAlarmAction(TKinokoHistoryView* HistoryView);
    virtual ~TKinokoHistoryViewDisableAlarmAction();
    virtual void Execute(void) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent);
  protected:
    TKinokoHistoryView* _HistoryView;
};



#include <KinokoAnalysisAction.hh>
class TKinokoViewSequenceTable;

class TKinokoAnalysisDispatchAction: public TKinokoAnalysisAction {
  public:
    TKinokoAnalysisDispatchAction(TKinokoViewSequenceTable* ViewSequenceTable, const std::string& EventName, const std::vector<std::string>& EventArgumentList);
    virtual ~TKinokoAnalysisDispatchAction();
    virtual void Execute(void) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    TKinokoViewSequenceTable* _ViewSequenceTable;
    std::string _EventName;
    std::vector<std::string> _EventArgumentList;
};


#endif
