/* KinokoViewCanvas.hh */
/* Created by Enomoto Sanshiro on 14 June 2002. */
/* Last updated by Enomoto Sanshiro on 1 September 2008. */


#ifndef __KinokoViewCanvas_hh__
#define __KinokoViewCanvas_hh__


#include <string>
#include <vector>
#include "KinokoView.hh"
#include "KinokoViewCanvasPage.hh"


class TKinokoViewCanvas {
  public:
    TKinokoViewCanvas(void);
    virtual ~TKinokoViewCanvas();
    virtual void DestroyViews(void);
    virtual void AddView(TKinokoView* View);
    virtual void AddPage(TKinokoViewCanvasPage* Page);
    virtual int NumberOfPages(void);
    virtual void DeployViews(void) = 0;
    virtual void Update(void) = 0;
    virtual void Clear(void) = 0;
    virtual void DrawAll(void);
    virtual int SaveImage(const std::string& ImageFileName) = 0;
  protected:
    std::vector<TKinokoViewCanvasPage*> _PageList;
    std::vector<TKinokoView*> _ViewList;
};


class TKinokoKoapViewCanvas: public TKinokoViewCanvas {
  public:
    TKinokoKoapViewCanvas(std::ostream* OutputStream);
    virtual ~TKinokoKoapViewCanvas();
    virtual void DeployViews(void);
    virtual void Update(void);
    virtual void Clear(void);
    virtual int SaveImage(const std::string& ImageFileName);
  protected:
    std::ostream* _OutputStream;
};


#endif
