/* KinokoViewCanvasPage.cc */
/* Created by Enomoto Sanshiro on 1 September 2008. */
/* Last updated by Enomoto Sanshiro on 1 September 2008. */


#include <string>
#include <vector>
#include "KinokoViewCanvasPage.hh"

using namespace std;


TKinokoViewCanvasPage::TKinokoViewCanvasPage(int PageNumber, const std::string& PageName)
{
    _PageNumber = PageNumber;
    _PageName = PageName;

    _RootFrame = new TKinokoViewGridFrame();
}

TKinokoViewCanvasPage::~TKinokoViewCanvasPage()
{
    delete _RootFrame;
}

void TKinokoViewCanvasPage::AddView(TKinokoView* View)
{
    _RootFrame->AddView(View);
}

void TKinokoViewCanvasPage::DeployViews(void)
{
    _RootFrame->SetPage(_PageNumber);
    _RootFrame->SetPosition(0, 0, 1.0, 1.0);
    _RootFrame->Deploy();
}



TKinokoKoapViewCanvasPage::TKinokoKoapViewCanvasPage(int PageNumber, const std::string& PageName, std::ostream* OutputStream)
: TKinokoViewCanvasPage(PageNumber, PageName)
{
    _OutputStream = OutputStream;
}

TKinokoKoapViewCanvasPage::~TKinokoKoapViewCanvasPage()
{
}

void TKinokoKoapViewCanvasPage::DeployViews(void)
{
    if (_PageNumber == 0) {
	*_OutputStream << ".selectPage " << _PageNumber << ";" << endl;
	*_OutputStream << ".set pagetitle " << _PageName << ";" << endl;
    }
    else {
	*_OutputStream << ".createPage " << _PageName << ";" << endl;
	*_OutputStream << ".selectPage " << _PageNumber << ";" << endl;
    }

    *_OutputStream << ".set background white;" << endl;
    *_OutputStream << ".set redraw manual;" << endl;

    TKinokoViewCanvasPage::DeployViews();
    *_OutputStream << ".redraw;" << endl;
}
