/* KinokoViewScriptStatement.hh */
/* Created by Enomoto Sanshiro on 26 December 2000. */
/* Last updated by Enomoto Sanshiro on 23 September 2001. */


#ifndef __KinokoViewScriptStatement_hh__
#define __KinokoViewScriptStatement_hh__


#include <string>
#include <map>
#include "ParaParser.hh"
#include "KinokoViewBuilder.hh"


class TKinokoViewScriptOnStatement: public TParaStatement {
  public:
    TKinokoViewScriptOnStatement(TKinokoViewBuilder* ViewBuilder);
    virtual ~TKinokoViewScriptOnStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKinokoViewBuilder* _ViewBuilder;
    TKinokoViewScriptOnStatement* _ConcreteStatement;
};


class TKinokoViewScriptOnEveryStatement: public TKinokoViewScriptOnStatement {
  public:
    TKinokoViewScriptOnEveryStatement(TKinokoViewBuilder* ViewBuilder);
    virtual ~TKinokoViewScriptOnEveryStatement();
    virtual TParaStatement* Clone(void);
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TParaExpression* _IntervalExpression;
    TParaStatement* _Statement;
};


class TKinokoViewScriptOnCommandStatement: public TKinokoViewScriptOnStatement {
  public:
    TKinokoViewScriptOnCommandStatement(TKinokoViewBuilder* ViewBuilder);
    virtual ~TKinokoViewScriptOnCommandStatement();
    virtual TParaStatement* Clone(void);
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TParaStatement* _Statement;
    std::string _CommandName;
};


class TKinokoViewScriptOnTrapStatement: public TKinokoViewScriptOnStatement {
  public:
    TKinokoViewScriptOnTrapStatement(TKinokoViewBuilder* ViewBuilder);
    virtual ~TKinokoViewScriptOnTrapStatement();
    virtual TParaStatement* Clone(void);
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TParaStatement* _Statement;
    long _TrapId;
};




class TKinokoAnalysisScriptDispatchStatement: public TParaStatement {
  public:
    TKinokoAnalysisScriptDispatchStatement(TKinokoAnalysisSequenceBuilder* AnalysisSequenceBuilder, TKinokoViewBuilder* ViewBuilder);
    virtual ~TKinokoAnalysisScriptDispatchStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKinokoViewBuilder* _ViewBuilder;
    TKinokoAnalysisSequenceBuilder* _AnalysisSequenceBuilder;
    std::string _EventName;
    std::vector<TParaExpression*> _EventArgumentExpressionList;
};


#endif
