/* KinokoWaveView.cc */
/* Created by Enomoto Sanshiro on 2 April 2001. */
/* Last updated by Enomoto Sanshiro on 2 April 2001. */


#include <cmath>
#include "KameNtuple.hh"
#include "KameRepository.hh"
#include "KinokoWaveView.hh"

using namespace std;
using namespace kame;


TKinokoWaveView::TKinokoWaveView(TKameNtuple* Ntuple, double XMin, double XMax, double YMin, double YMax)
{
    _Ntuple = Ntuple;

    _XMin = XMin;
    _XMax = XMax;
    _YMin = YMin;
    _YMax = YMax;
}

TKinokoWaveView::~TKinokoWaveView()
{
    delete _Ntuple;
}

void TKinokoWaveView::SetAxisTitle(const std::string& XTitle, const std::string& YTitle)
{
    _XTitle = XTitle;
    _YTitle = YTitle;
}

void TKinokoWaveView::SaveThis(TKameRepository* Repository)throw(TKinokoException)
{
    try {
	Repository->SaveNtuple(*_Ntuple, _Name);
    }
    catch (TKameException &e) {
	throw TKinokoException(
	    "TKinokoWaveView::SaveThis()", e.Message()
	);
    }
}


void TKinokoWaveView::ClearThis(void)
{
    _Ntuple->Clear();
}


TKinokoKoapWaveView::TKinokoKoapWaveView(TKameNtuple* Ntuple, double XMin, double XMax, double YMin, double YMax, ostream* OutputStream)
: TKinokoWaveView(Ntuple, XMin, XMax, YMin, YMax)
{
    _OutputStream = OutputStream;
}

TKinokoKoapWaveView::~TKinokoKoapWaveView()
{
}

void TKinokoKoapWaveView::DeployThis(void) 
{
    *_OutputStream << ".selectPage " << _PageNumber << ";" << endl;

    (*_OutputStream) << ".create plot " << _Name << " ";
    (*_OutputStream) << 100 * Left() << " " << 100 * Top() << " ";
    (*_OutputStream) << 100 * Width() << " " << 100 * Height() << ";" << endl;

    (*_OutputStream) << _Name << " set title " << _Ntuple->Title() << ";" << endl;
    if (! _XTitle.empty()) {
	(*_OutputStream) << _Name << " set xtitle " << _XTitle << ";" << endl;
    }
    if (! _YTitle.empty()) {
	(*_OutputStream) << _Name << " set ytitle " << _YTitle << ";" << endl;
    }

    (*_OutputStream) << _Name << " frame ";
    (*_OutputStream) << _XMin << " " << _XMax << " ";
    (*_OutputStream) << _YMin << " " << _YMax << ";" << endl;
}

void TKinokoKoapWaveView::DrawThis(void)
{
    (*_OutputStream) << _Name << " clear;" << endl;
    (*_OutputStream) << _Name << " frame ";
    (*_OutputStream) << _XMin << " " << _XMax << " ";
    (*_OutputStream) << _YMin << " " << _YMax << ";" << endl;

    if (_Ntuple->NumberOfRows() == 0) {
        (*_OutputStream) << _Name << " drawtext ";
        (*_OutputStream) << (7 * _XMin + _XMax) / 8 << " ";
        (*_OutputStream) << (_YMin + _YMax) / 2 << " ";
        (*_OutputStream) << "no data;" << endl;
	return;
    }

    (*_OutputStream) << _Name << " linesplot ";
    int NumberOfPoints = _Ntuple->NumberOfRows();
    for (int Index = 0; Index < NumberOfPoints; Index++) {
	double Value = (*_Ntuple)[Index][0]; 
	long Weight = (*_Ntuple)[Index][1];
	if ((Index >= _XMin) && (Index <= _XMax)) {
	    (*_OutputStream) << " " << Index << " " << (Value/Weight);
	}
    }
    (*_OutputStream) << ";" << endl;

    (*_OutputStream) << _Name << " drawframe;";
}

void TKinokoKoapWaveView::ClearThis(void)
{
    TKinokoWaveView::ClearThis();
    
    (*_OutputStream) << _Name << " clear;" << endl;
    (*_OutputStream) << _Name << " frame ";
    (*_OutputStream) << _XMin << " " << _XMax << " ";
    (*_OutputStream) << _YMin << " " << _YMax << ";" << endl;
}
