/* ktscheck.cc */
/* Created by Enomoto Sanshiro on 18 July 2001 */
/* Last updated by Enomoto Sanshiro on 18 July 2001. */


#include <iostream>
#include <string>
#include <cstdlib>
#include "KcomManager.hh"
#include "KcomRegistry.hh"
#include "KcomEventProcessor.hh"
#include "KcomComponentAssembler.hh"
#include "KcomObjectAssembler.hh"
#include "KcomScript.hh"
#include "KcomScriptedManager.hh"
#include "KinokoDefs.hh"

using namespace std;


class TKcomScriptChecker {
  public:
    TKcomScriptChecker(const string& ScriptFileName);
    virtual ~TKcomScriptChecker();
    virtual void Start(void) throw(TKinokoException);
  protected:
    string _ScriptFileName;
};



TKcomScriptChecker::TKcomScriptChecker(const string& ScriptFileName)
{
    _ScriptFileName = ScriptFileName;
}

TKcomScriptChecker::~TKcomScriptChecker()
{
}

void TKcomScriptChecker::Start(void) throw(TKinokoException)
{
    ifstream ScriptFile(_ScriptFileName.c_str());
    if (! ScriptFile) {
	throw TKinokoException(
	    "unable to find file: " + _ScriptFileName
	);
    }

    int argc = 0; char** argv = 0;
    TKcomManager* Manager = new TKcomScriptedManager(
	_ScriptFileName, argc, argv
    );

    TKcomScript* Script = new TKcomScript(Manager, argc, argv);

    try {
	Script->Parse(ScriptFile);
    }
    catch (TScriptException &e) {
	throw TKinokoException(e.Message());
    }

    delete Script;
    delete Manager;
}


int main(int argc, char **argv)
{
    if (argc < 2) {
	cerr << "usage: " << argv[0] << " script-file-name" << endl;
	return EXIT_FAILURE;
    }
    string ScriptFileName = argv[1];
    
    try {
	TKcomScriptChecker(ScriptFileName).Start();
    }
    catch (TKinokoException &e) {
	cout << e << endl;
    }

    return 0;
}
