/* kdftable.cc */
/* Created by Enomoto Sanshiro on 25 October 1999. */
/* Last updated by Enomoto Sanshiro on 23 February 2002. */


#include <cstdlib>
#include <iostream>
#include <string>
#include "MushArgumentList.hh"
#include "KinokoKdfReader.hh"
#include "KinokoDataDumper.hh"

using namespace std;


int main(int argc, char** argv)
{
    TMushArgumentList ArgumentList(argc, argv);

    if (ArgumentList.NumberOfParameters() < 1) {
	cerr << "Usage: " << ArgumentList.ProgramName();
	cerr << " DataFileName [ DataSourceName]" << endl;
	cerr << "Parameters:" << endl;
	cerr << "  DataFileName      input KDF data file name" << endl;
	cerr << "  DataSourceName    datasource name to display; omit it for all, use '-' for an arbitrary one" << endl;
	cerr << "Options:" << endl;
	cerr << "  --format=N      outputs in old version format" << endl;
        return EXIT_FAILURE;
    }

    string DataFileName = ArgumentList[0];
    string DataSourceName = "";
    if (ArgumentList.NumberOfParameters() > 1) {
	DataSourceName = ArgumentList[1];
    }
    if (DataSourceName == "-") {
	DataSourceName = "";
    }

    int FormatVersion;
    try {
	FormatVersion = ArgumentList.IntOptionValueOf("--format", 0);
    }
    catch (TSystemCallException &e) {
	cerr << "ERROR: " << e << endl;
	return EXIT_FAILURE;
    }

    TKinokoKdfReader* KdfReader = new TKinokoKdfReader(DataFileName);
    TKinokoDataTabler* Analyzer = new TKinokoDataTabler(cout, FormatVersion);
    
    for (int Index = 2; Index < ArgumentList.NumberOfParameters(); Index++) {
	Analyzer->AddTargetSection(ArgumentList[Index]);
    }

    try {
	KdfReader->RegisterAnalyzer(DataSourceName, Analyzer);

	KdfReader->StorageHeader()->WriteTo(cout, "# ");
	cout << endl;

	KdfReader->Start();
    }
    catch (TKinokoException& e) {
	cerr << "ERROR: " << e << endl;
        return EXIT_FAILURE;
    }

    delete Analyzer;
    delete KdfReader;

    return 0;
}
