/* kinoko-script.cc */
/* Created by Enomoto Sanshiro on 14 December 2001. */
/* Last updated by Enomoto Sanshiro on 29 May 2008. */


#include <iostream>
#include <MushFileSystem.hh>
#include <MushMisc.hh>
#include <KiscInterpreter.hh>

using namespace std;


int main(int argc, char** argv)
{
    try {
	TKiscInterpreter Interpreter(argc, argv);

	string ConfigPath = TMushUser().HomeDirectory() + "/.kinoko-script";
	if (! TMushFileAttribute(ConfigPath).Exists()) {
	    TMushFileSystem::MakeDirectory(ConfigPath);
	}

	string HistoryFile = ConfigPath + "/history";
	string StartupScript = ConfigPath + "/startup.kino";
	string StartupLocalScript = "startup.kino";

	if (TMushFileAttribute(StartupLocalScript).IsReadableFile()) {
	    Interpreter.AddStartupFile(StartupLocalScript);
	}
	if (TMushFileAttribute(StartupScript).IsReadableFile()) {
	    Interpreter.AddStartupFile(StartupScript);
	}
	Interpreter.SetHistoryFile(HistoryFile);
	
	Interpreter.Start();
    }
    catch (TScriptException &e) {
	cerr << "ERROR: " << e << endl;
    }

    return 0;
}
