/* ktscheck.cc */
/* Created by Enomoto Sanshiro on 18 July 2001 */
/* Last updated by Enomoto Sanshiro on 1 May 2002. */


#include <iostream>
#include <string>
#include <cstdlib>
#include "MushSignal.hh"
#include "MushArgumentList.hh"
#include "KinokoScriptedDaqBuilder.hh"
#include "KinokoDaqScript.hh"

using namespace std;


class TKtsChecker {
  public:
    TKtsChecker(const string& ScriptFileName, const string& DataSourceName, bool ShowsSequence);
    virtual ~TKtsChecker();
    virtual void Start(void) throw(TKinokoException);
  protected:
    string _ScriptFileName;
    string _DataSourceName;
    bool _ShowsSequence;
};



TKtsChecker::TKtsChecker(const string& ScriptFileName, const string& DataSourceName, bool ShowsSequence)
{
    _ScriptFileName = ScriptFileName;
    _DataSourceName = DataSourceName;
    _ShowsSequence = ShowsSequence;
}

TKtsChecker::~TKtsChecker()
{
}

void TKtsChecker::Start(void) throw(TKinokoException)
{
    ifstream ScriptFile(_ScriptFileName.c_str());
    if (! ScriptFile) {
	throw TKinokoException("unable to open file: " + _ScriptFileName);
    }

    int DataSourceId = 1;
    bool IsScriptTest = true;
    TKinokoOutputStream* OutputStream = 0;
    TKinokoEventEmitter* EventEmitter = new TKinokoEventEmitter();
    TKinokoRegistry* Registry = new TKinokoNullRegistry();
    TKinokoDaqBuilder* DaqBuilder = new TKinokoScriptedDaqBuilder(
	_ScriptFileName, _DataSourceName, DataSourceId, 
	OutputStream, EventEmitter, Registry, IsScriptTest = true
    );
    
    try {
	TKinokoTransaction* Transaction = DaqBuilder->Transaction();
	if (_ShowsSequence) {
	    Transaction->Dump(cout);
	}
    }
    catch (TScriptException &e) {
        throw TKinokoException(e.Message());
    }
    catch (TKinokoException &e) {
        throw;
    }

    delete DaqBuilder;
}


int main(int argc, char **argv)
{
    TMushSignalHandler SignalHandler;
    SignalHandler.StartDefaultAction(SIGSEGV);
    SignalHandler.StartDefaultAction(SIGPIPE);

    if (argc < 2) {
	cerr << "Usage: " << argv[0];
	cerr << " [Options] ScriptFileName [DataSourceName]" << endl;
	cerr << "Options:" << endl;
	cerr << "  --show-sequence  dumps sequence" << endl;
	return EXIT_FAILURE;
    }

    TMushArgumentList ArgumentList(argc, argv);
    string ScriptFileName = ArgumentList[0];
    string DataSourceName = ArgumentList[1];
    bool ShowsSequence = ArgumentList.IsOptionSpecified("--show-sequence");
    
    try {
	TKtsChecker(ScriptFileName, DataSourceName, ShowsSequence).Start();
    }
    catch (TKinokoException &e) {
	cout << e << endl;
    }

    return 0;
}
