/* KinokoCanvas.hh */
/* Created by Enomoto Sanshiro on 9 July 2000. */
/* Last updated by Enomoto Sanshiro on 27 March 2002. */


#ifndef __KinokoCanvas_hh
#define __KinokoCanvas_hh


#include <iostream>
#include <string>
#include "KinokoShell.hh"
#include "KinokoCanvasImageArea.hh"
#include "KinokoCanvasImageAreaEps.hh"
#include "KinokoCanvasObject.hh"


class TKinokoCanvasPage;

class TKinokoCanvas: public TKinokoShell {
  public:
    TKinokoCanvas(TKinokoShellConnector* ShellConnector);
    virtual ~TKinokoCanvas();
  public:
    virtual int CreatePage(const std::string& PageName = "");
    virtual int SelectPage(int PageNumber);
    virtual TKinokoCanvasImageArea* ImageArea(void);
    virtual int SetTitle(const std::string& Title);
    virtual int SetPageTitle(const std::string& Title);
    virtual int Redraw(int PageNumber = -1);
    virtual int Reset(void);
    virtual int Clear(int PageNumber = -1);
    virtual int SetBackgroundColor(const std::string& ColorName);
    virtual int SaveImageTo(const std::string& FileName);
    virtual void OnButtonPress(int PageNumber, int ButtonNumber, int X, int Y);
    virtual void OnButtonRelease(int PageNumber, int ButtonNumber, int X, int Y);
    virtual void OnMouseMove(int PageNumber, int X, int Y);
    virtual int OpenContextMenu(TKinokoCanvasObject* CanvasObject) = 0;
    virtual int AddPage(TKinokoCanvasImageArea* ImageArea, bool IsEpsEnabled = false);
    virtual void AddCanvasObject(TKinokoCanvasObject* CanvasObject);
  protected:
    virtual void ConstructPrototypeTable(void);
    virtual int ProcessSystemCommand(const std::string& Command, std::istream& InputStream);
    virtual int ProcessCommand(std::istream& InputStream);
    virtual int ProcessSetCommand(std::istream& InputStream);
    virtual int ProcessRedrawCommand(std::istream& InputStream);
    virtual int ProcessResetCommand(std::istream& InputStream);
    virtual int ProcessClearCommand(std::istream& InputStream);
    virtual int ProcessSaveImageCommand(std::istream& InputStream);
    virtual int ProcessBeginEpsCommand(std::istream& InputStream);
    virtual int ProcessEndEpsCommand(std::istream& InputStream);
    virtual int ProcessSetEpsUnitSizeCommand(std::istream& InputStream);
    virtual int ProcessCreatePageCommand(std::istream& InputStream);
    virtual int ProcessSelectPageCommand(std::istream& InputStream);
  protected:
    std::vector<TKinokoCanvasPage*> _CanvasPageList;
    TKinokoCanvasPage* _CurrentPage;
    int _CurrentPageNumber;
    bool _IsAutoRedrawEnabled;
};



class TKinokoCanvasPage {
  public:
    TKinokoCanvasPage(TKinokoCanvas* Canvas, TKinokoCanvasImageArea* ImageArea, bool IsEpsEnabled);
    virtual ~TKinokoCanvasPage();
    virtual TKinokoCanvasImageArea* ImageArea(void);
    virtual void AddCanvasObject(TKinokoCanvasObject* CanvasObject);
    virtual int Redraw(void);
    virtual int Clear(void);
    virtual int SetBackgroundColor(const std::string& ColorName);
    virtual int SaveImageTo(const std::string& FileName);
    virtual int BeginEps(const std::string& FileName);
    virtual int EndEps(void);
    virtual int SetEpsUnitSize(double PixelsPerInch);
    virtual void OnButtonPress(int ButtonNumber, int X, int Y);
    virtual void OnButtonRelease(int ButtonNumber, int X, int Y);
    virtual void OnMouseMove(int X, int Y);
  protected:
    TKinokoCanvas* _Canvas;
    TKinokoCanvasImageArea* _ImageArea;
    TKinokoCanvasImageAreaEps* _EpsImageArea;
    std::vector<TKinokoCanvasObject*> _CanvasObjectList;
  private:
    bool _IsInRangeSelectionMode;
    int _X0, _Y0, _X1, _Y1;
};


#endif
