/* KinokoCanvasColorScale.hh */
/* Created by Enomoto Sanshiro on 14 January 2001. */
/* Last updated by Enomoto Sanshiro on 14 January 2001. */


#ifndef __KinokoCanvasColorScale_hh
#define __KinokoCanvasColorScale_hh


#include "KinokoCanvas.hh"
#include "KinokoCanvasImageArea.hh"


class TKinokoCanvasColorScale {
  public:
    TKinokoCanvasColorScale(TKinokoCanvas* Canvas, int NumberOfColors);
    virtual ~TKinokoCanvasColorScale();
    virtual int ColorIndexOf(double Value);
    virtual void Initialize(void);
  protected:
    virtual void CreateColorTable(void) = 0;
  protected:
    TKinokoCanvas* _Canvas;
    TKinokoCanvasImageArea* _ImageArea;
    int _NumberOfColors;
    int* _ColorTable;
};


class TKinokoCanvasGrayColorScale: public TKinokoCanvasColorScale {
  public:
    TKinokoCanvasGrayColorScale(TKinokoCanvas* Canvas, int NumberOfColors = 256);
    virtual ~TKinokoCanvasGrayColorScale();
  protected:
    virtual void CreateColorTable(void);
};


class TKinokoCanvasTwoColorScale: public TKinokoCanvasColorScale {
  public:
    TKinokoCanvasTwoColorScale(TKinokoCanvas* Canvas, int NumberOfColors = 256);
    virtual ~TKinokoCanvasTwoColorScale();
  protected:
    virtual void CreateColorTable(void);
};


class TKinokoCanvasRainbowColorScale: public TKinokoCanvasColorScale {
  public:
    TKinokoCanvasRainbowColorScale(TKinokoCanvas* Canvas, int NumberOfColors = 256);
    virtual ~TKinokoCanvasRainbowColorScale();
    static void HSV2RGB(float h, float s, float v, float& r, float& g, float& b);
  protected:
    virtual void CreateColorTable(void);
};


class TKinokoCanvasWhiteBackgroundRainbowColorScale: public TKinokoCanvasRainbowColorScale {
  public:
    TKinokoCanvasWhiteBackgroundRainbowColorScale(TKinokoCanvas* Canvas, int NumberOfColors = 256);
    virtual ~TKinokoCanvasWhiteBackgroundRainbowColorScale();
    virtual int ColorIndexOf(double Value);
  protected:
    virtual void CreateColorTable(void);
  protected:
    int _BackgroundColor;
};


class TKinokoCanvasBlackBackgroundRainbowColorScale: public TKinokoCanvasRainbowColorScale {
  public:
    TKinokoCanvasBlackBackgroundRainbowColorScale(TKinokoCanvas* Canvas, int NumberOfColors = 256);
    virtual ~TKinokoCanvasBlackBackgroundRainbowColorScale();
    virtual int ColorIndexOf(double Value);
  protected:
    virtual void CreateColorTable(void);
  protected:
    int _BackgroundColor;
};


class TKinokoCanvasGrayBackgroundRainbowColorScale: public TKinokoCanvasRainbowColorScale {
  public:
    TKinokoCanvasGrayBackgroundRainbowColorScale(TKinokoCanvas* Canvas, int NumberOfColors = 256);
    virtual ~TKinokoCanvasGrayBackgroundRainbowColorScale();
    virtual int ColorIndexOf(double Value);
  protected:
    virtual void CreateColorTable(void);
  protected:
    int _BackgroundColor;
};


#endif
