/* KinokoCanvasDataScale.hh */
/* Created by Enomoto Sanshiro on 11 July 2000. */
/* Last updated by Enomoto Sanshiro on 7 December 2003. */


#ifndef __KinokoCanvasDataScale_hh
#define __KinokoCanvasDataScale_hh


#include <vector>


class TKinokoCanvasDataScale {
  public:
    TKinokoCanvasDataScale(float Min = 0, float Max = 1.0, int MaxNumberOfDivisions = 10);
    virtual ~TKinokoCanvasDataScale();
    virtual TKinokoCanvasDataScale& Rescale(float Min, float Max, int MaxNumberOfDivisions = 10);
    virtual std::string FactorizeScaleLabel(void);
    virtual float Min(void) const;
    virtual float Max(void) const;
    virtual float Width(void) const;
    virtual int NumberOfDivisions(void);
    virtual float DivisionValueOf(int DivisionIndex);
    virtual std::string DivisionLabelOf(int DivisionIndex);
    virtual int NumberOfTicks(void);
    virtual float TickValueOf(int TickIndex);
  protected:
    virtual std::pair<float, float> DecideSteps(float Min, float Max, int MaxNumberOfSteps);
  protected:
    float _Min, _Max, _Width;
    float _LabelScalingFactor;
    int _MaxNumberOfDivisions;
    float _FirstDivision, _LastDivision, _DivisionStep;
    int _NumberOfDivisions;
    float _FirstTick, _TickStep;
    int _NumberOfTicks;
  private:
    float _UsedMin, _UsedMax;
};


class TKinokoCanvasLogDataScale: public TKinokoCanvasDataScale {
  public:
    TKinokoCanvasLogDataScale(float Min = 0.1, float Max = 1.0, int MaxNumberOfDivisions = 10);
    virtual ~TKinokoCanvasLogDataScale();
    virtual TKinokoCanvasDataScale& Rescale(float Min, float Max, int MaxNumberOfDivisions = 10);
    virtual std::string FactorizeScaleLabel(void);
    virtual int NumberOfDivisions(void);
    virtual float DivisionValueOf(int DivisionIndex);
    virtual std::string DivisionLabelOf(int DivisionIndex);
    virtual int NumberOfTicks(void);
    virtual float TickValueOf(int TickIndex);
  protected:
    bool _IsUsingNormalScale;
    int _TickIndexOffset;
};


class TKinokoCanvasTimeDataScale: public TKinokoCanvasDataScale {
  public:
    TKinokoCanvasTimeDataScale(float Min, float Max, int MaxNumberOfDivisions = 10);
    virtual ~TKinokoCanvasTimeDataScale();
    virtual void SetTimeTick(long Epoch = 0, const std::string& Format = "", int Unit = 0, int Step = 0);
    virtual TKinokoCanvasDataScale& Rescale(float Min, float Max, int MaxNumberOfDivisions = 10);
    virtual std::string FactorizeScaleLabel(void);
    virtual int NumberOfDivisions(void);
    virtual float DivisionValueOf(int DivisionIndex);
    virtual std::string DivisionLabelOf(int DivisionIndex);
    virtual int NumberOfTicks(void);
    virtual float TickValueOf(int TickIndex);
  protected:
    virtual void SetDivisions();
    virtual void RegulateDate(int& Year, int& Month, int& Day, int& Hour, int& Min, int& Sec);
  protected:
    long _Epoch;
    int _Unit, _Step;
    std::string _Format;
    std::vector<std::pair<double, std::string> > _DivisionList;
    std::vector<double> _TickList;
  public:
    enum TTimeUnit {
	TimeUnit_Undefined = 0,
	TimeUnit_Second,
	TimeUnit_Minute,
	TimeUnit_Hour,
	TimeUnit_Day,
	TimeUnit_Month,
	TimeUnit_Year,
	_NumberOfTimeUnits
    };
};


class TKinokoCanvasElapseDataScale: public TKinokoCanvasDataScale {
  public:
    TKinokoCanvasElapseDataScale(float Min, float Max, int MaxNumberOfDivisions = 10);
    virtual ~TKinokoCanvasElapseDataScale();
    virtual std::string FactorizeScaleLabel(void);
    virtual std::string DivisionLabelOf(int DivisionIndex);
  protected:
    virtual std::pair<float, float> DecideSteps(float Min, float Max, int MaxNumberOfSteps);
};


#endif
