/* KinokoCanvasDrawableObject.hh */
/* Created by Enomoto Sanshiro on 11 July 2000. */
/* Last updated by Enomoto Sanshiro on 12 June 2004. */


#ifndef __KinokoCanvasDrawableObject_hh
#define __KinokoCanvasDrawableObject_hh


#include <iostream>
#include <string>
#include <deque>
#include <map>
#include "KinokoCanvasMarker.hh"
#include "KinokoCanvasTypesetter.hh"
#include "KinokoCanvasObject.hh"


class TKinokoCanvasDrawableObject: public TKinokoCanvasObject {
  public:
    TKinokoCanvasDrawableObject(TKinokoCanvas* Canvas);
    virtual ~TKinokoCanvasDrawableObject();
    virtual void Initialize(void);
    virtual void SetPosition(int OffsetX, int OffsetY, int Width, int Height);
    virtual void Clear(void);
  protected:
    virtual int ProcessCommand(const std::string& Command, std::istream& InputStream);
    virtual int ProcessSetCommand(const std::string& Name, const std::string& Value);
    virtual int ProcessDrawPointCommand(std::istream& InputStream);
    virtual int ProcessDrawLineCommand(std::istream& InputStream);
    virtual int ProcessDrawRectCommand(std::istream& InputStream, bool IsFilled);
    virtual int ProcessDrawPolygonCommand(std::istream& InputStream, bool IsFilled);
    virtual int ProcessDrawCircleCommand(std::istream& InputStream, bool IsFilled);
    virtual int ProcessDrawEllipseCommand(std::istream& InputStream, bool IsFilled);
    virtual int ProcessDrawArrowTipCommand(std::istream& InputStream, bool IsFilled);
    virtual int ProcessDrawTextCommand(std::istream& InputStream);
    virtual int ProcessDrawImageCommand(std::istream& InputStream);
    virtual int ProcessLocateCommand(std::istream& InputStream);
    virtual int ProcessPrintCommand(std::istream& InputStream, bool FeedsLine);
    virtual int ProcessClearCommand(std::istream& InputStream);
    virtual int ProcessSetFontCommand(std::istream& InputStream);
    virtual int ProcessSaveContextCommand(std::istream& InputStream);
    virtual int ProcessRestoreContextCommand(std::istream& InputStream);
  public:
    virtual float CanvasXOf(float x);
    virtual float CanvasYOf(float y);
    virtual float XOf(float CanvasX);
    virtual float YOf(float CanvasY);
  protected:
    virtual int SetCoordinate(float XMin, float YMin, float XWidth, float YWidth);
    virtual int SaveContext(void);
    virtual int RestoreContext(void);
    virtual int PopContextStack(void);
  protected:
    int SetForegroundColor(const std::string& ColorName);
    int SetBackgroundColor(const std::string& ColorName);
    int SetColor(const std::string& ColorName = "");
    int SetFont(std::string FontName = "", int FontSize = -1);
    int SetLineWidth(const std::string& LineWidthString);
    int SetLineStyle(const std::string& LineStyleString);
    int SetTextAdjustment(const std::string& AdjustmentString);
    int SetMarker(std::string MarkerName);
    int SetMarkerSize(const std::string& MarkerSizeString);
  protected:
    int _ColorIndex;
    int _LineWidth;
    int _LineStyleIndex;
    int _FontIndex;
    int _LineHeight;
    TKinokoCanvasMarker *_Marker;
    int _MarkerSize;
    std::string _TextAdjustment;
    float _XMin, _XMax, _YMin, _YMax, _XWidth, _YWidth;
    float _DrawableXMin, _DrawableXMax, _DrawableYMin, _DrawableYMax;
    TKinokoCanvasMarkerFactory *_MarkerFactory;
    TKinokoCanvasMathTextComposer* _MathTextComposer;
    double _CursorX, _CursorY, _CursorX0;
    std::map<int, int> _LineHeightTable;
  private:
    std::deque<int> _ColorIndexStack;
    std::deque<int> _LineWidthStack;
    std::deque<int> _LineStyleIndexStack;
    std::deque<int> _FontIndexStack;
    std::deque<std::string> _TextAdjustmentStack;
    std::deque<int> _LineHeightStack;
    std::deque<TKinokoCanvasMarker*> _MarkerStack;
    std::deque<int> _MarkerSizeStack;
};


#endif
