/* KinokoCanvasFramedObject.hh */
/* Created by Enomoto Sanshiro on 11 July 2000. */
/* Last updated by Enomoto Sanshiro on 9 January 2002. */


#ifndef __KinokoCanvasFramedObject_hh
#define __KinokoCanvasFramedObject_hh


#include <string>
#include <iostream>
#include "KinokoCanvasDataScale.hh"
#include "KinokoCanvasColorScale.hh"
#include "KinokoCanvasDrawableObject.hh"


class TKinokoCanvasFramedObject: public TKinokoCanvasDrawableObject {
  public:
    TKinokoCanvasFramedObject(TKinokoCanvas* Canvas);
    virtual ~TKinokoCanvasFramedObject();
    virtual void Initialize(void);
    virtual void SetMargin(float Top, float Bottom, float Left, float Right);
    virtual void SetPosition(int OffsetX, int OffsetY, int Width, int Height);
    virtual void SetContentBackgroundColor(const std::string& ColorName);
    virtual void FreezeFrame(float XMin, float XMax, float YMin, float YMax);
    virtual void ThawFrame(void);
    virtual void Clear(void);
  protected:
    virtual int ProcessCommand(const std::string& Command, std::istream& InputStream);
    virtual int ProcessSetCommand(const std::string& Name, const std::string& Value);
    virtual int ProcessFrameCommand(std::istream& InputStream);
    virtual int ProcessDrawFrameCommand(std::istream& InputStream);
    virtual int ProcessSetMarginCommand(std::istream& InputStream);
  public:
    virtual float CanvasXOf(float x);
    virtual float CanvasYOf(float y);
    virtual float XOf(float CanvasX);
    virtual float YOf(float CanvasY);
  protected:
    virtual int SetTitle(const std::string& Title);
    virtual int DrawFrame(void);
  protected:
    std::string _Title;
    int _TopMargin, _BottomMargin, _LeftMargin, _RightMargin;
    int _FrameOffsetX, _FrameOffsetY, _FrameWidth, _FrameHeight;
    int _TitleOffsetX, _TitleOffsetY;
    bool _IsFrameValid, _IsFrameFrozen;
    int _ContentBackgroundColorIndex;
};


class TKinokoCanvasColorScaledObject: virtual public TKinokoCanvasFramedObject {
  public:
    TKinokoCanvasColorScaledObject(TKinokoCanvas* Canvas, TKinokoCanvasColorScale* ColorScale);
    virtual ~TKinokoCanvasColorScaledObject();
    virtual void Initialize(void);
  protected:
    virtual int ProcessFrameCommand(std::istream& InputStream);
    protected:
    virtual int SetZCoordinate(float ZMin, float ZWidth);
    virtual int SetZScaleLinear(void);
    virtual int SetZScaleLog(void);
    virtual int EnableZScaleLabel(void);
    virtual int DisableZScaleLabel(void);
    virtual int DrawFrame(void);
  protected:
    float _ZMin, _ZMax, _ZWidth;
    float _LogZMin, _LogZMax, _LogZWidth;
    float _ZMinOrg, _ZWidthOrg;
    bool _IsZScaleLog;
    TKinokoCanvasDataScale *_ZScale;
    int _NumberOfZScaleLabels;
    int _ZScaleWidth, _ZScaleBoxWidth;
    bool _IsZScaleLabelDisabled;
    bool _IsZScaleFactoringEnabled;
    TKinokoCanvasColorScale* _ColorScale;
    std::string _ZTitle;
};


#endif
