/* KinokoCanvasMarker.cc */
/* Created by Enomoto Sanshiro on 18 May 2002. */
/* Last updated by Enomoto Sanshiro on 18 May 2002. */


#include <string>
#include <map>
#include "KinokoCanvasImageArea.hh"
#include "KinokoCanvasMarker.hh"

using namespace std;


TKinokoCanvasMarker::TKinokoCanvasMarker(void)
{
}

TKinokoCanvasMarker::~TKinokoCanvasMarker()
{
}



TKinokoCanvasMarkerFactory::TKinokoCanvasMarkerFactory(void)
{
    _IsConstructed = false;
}

TKinokoCanvasMarkerFactory::~TKinokoCanvasMarkerFactory()
{
    map<string, TKinokoCanvasMarker*>::iterator MarkerEntry;
    for (
	MarkerEntry = _MarkerPrototypeTable.begin();
	MarkerEntry != _MarkerPrototypeTable.end();
	MarkerEntry++
    ){
	delete (*MarkerEntry).second;
    }
}

void TKinokoCanvasMarkerFactory::Construct(void)
{
    if (_IsConstructed) {
	return;
    }

    AddMarker("circle", new TKinokoCanvasCircleMarker());
    AddMarker("square", new TKinokoCanvasSquareMarker());
    AddMarker("triangle", new TKinokoCanvasTriangleMarker());
    AddMarker("diamond", new TKinokoCanvasDiamondMarker());
    AddMarker("opencircle", new TKinokoCanvasOpenCircleMarker());
    AddMarker("opensquare", new TKinokoCanvasOpenSquareMarker());
    AddMarker("opentriangle", new TKinokoCanvasOpenTriangleMarker());
    AddMarker("opendiamond", new TKinokoCanvasOpenDiamondMarker());

    AddMarker("image", new TKinokoCanvasImageMarker());
    AddMarker("xpm", new TKinokoCanvasImageMarker());
}

void TKinokoCanvasMarkerFactory::AddMarker(const string& Name, TKinokoCanvasMarker* Marker)
{
    _MarkerPrototypeTable[Name] = Marker;
}

TKinokoCanvasMarker* TKinokoCanvasMarkerFactory::CreateMarker(const string& Name, const string& Parameter)
{
    if (! _IsConstructed) {
	Construct();
    }

    if (_MarkerPrototypeTable.find(Name) == _MarkerPrototypeTable.end()) {
	return 0;
    }

    return _MarkerPrototypeTable[Name]->Clone(Parameter);
}



TKinokoCanvasMarker* TKinokoCanvasCircleMarker::Clone(const string& Parameter)
{
    return new TKinokoCanvasCircleMarker();
}

void TKinokoCanvasCircleMarker::Draw(TKinokoCanvasImageArea* _ImageArea, float X, float Y, float Size)
{
    _ImageArea->DrawCircleFill(X, Y, Size);
}



TKinokoCanvasMarker* TKinokoCanvasSquareMarker::Clone(const string& Parameter)
{
    return new TKinokoCanvasSquareMarker();
}

void TKinokoCanvasSquareMarker::Draw(TKinokoCanvasImageArea* _ImageArea, float X, float Y, float Size)
{
    Size /= 1.2;

    _ImageArea->DrawRectFill(X - Size, Y - Size, X + Size, Y + Size);
}



TKinokoCanvasMarker* TKinokoCanvasTriangleMarker::Clone(const string& Parameter)
{
    return new TKinokoCanvasTriangleMarker();
}

void TKinokoCanvasTriangleMarker::Draw(TKinokoCanvasImageArea* _ImageArea, float X, float Y, float Size)
{
    Size *= 1.2;

    vector<pair<float, float> > PointList;
    PointList.push_back(make_pair(X, Y - Size));
    PointList.push_back(make_pair(X - Size, Y + Size));
    PointList.push_back(make_pair(X + Size, Y + Size));

    _ImageArea->DrawPolygonFill(PointList);
}

TKinokoCanvasMarker* TKinokoCanvasDiamondMarker::Clone(const string& Parameter)
{
    return new TKinokoCanvasDiamondMarker();
}

void TKinokoCanvasDiamondMarker::Draw(TKinokoCanvasImageArea* _ImageArea, float X, float Y, float Size)
{
    Size *= 1.2;

    vector<pair<float, float> > PointList;
    PointList.push_back(make_pair(X, Y - Size));
    PointList.push_back(make_pair(X - Size, Y));
    PointList.push_back(make_pair(X, Y + Size));
    PointList.push_back(make_pair(X + Size, Y));

    _ImageArea->DrawPolygonFill(PointList);
}


TKinokoCanvasMarker* TKinokoCanvasOpenCircleMarker::Clone(const string& Parameter)
{
    return new TKinokoCanvasOpenCircleMarker();
}

void TKinokoCanvasOpenCircleMarker::Draw(TKinokoCanvasImageArea* _ImageArea, float X, float Y, float Size)
{
    _ImageArea->DrawCircle(X, Y, Size);
}



TKinokoCanvasMarker* TKinokoCanvasOpenSquareMarker::Clone(const string& Parameter)
{
    return new TKinokoCanvasOpenSquareMarker();
}

void TKinokoCanvasOpenSquareMarker::Draw(TKinokoCanvasImageArea* _ImageArea, float X, float Y, float Size)
{
    Size /= 1.2;
    _ImageArea->DrawRect(X - Size, Y - Size, X + Size, Y + Size);
}



TKinokoCanvasMarker* TKinokoCanvasOpenTriangleMarker::Clone(const string& Parameter)
{
    return new TKinokoCanvasOpenTriangleMarker();
}

void TKinokoCanvasOpenTriangleMarker::Draw(TKinokoCanvasImageArea* _ImageArea, float X, float Y, float Size)
{
    Size *= 1.2;

    vector<pair<float, float> > PointList;
    PointList.push_back(make_pair(X, Y - Size));
    PointList.push_back(make_pair(X - Size, Y + Size));
    PointList.push_back(make_pair(X + Size, Y + Size));

    _ImageArea->DrawPolygon(PointList);
}

TKinokoCanvasMarker* TKinokoCanvasOpenDiamondMarker::Clone(const string& Parameter)
{
    return new TKinokoCanvasOpenDiamondMarker();
}

void TKinokoCanvasOpenDiamondMarker::Draw(TKinokoCanvasImageArea* _ImageArea, float X, float Y, float Size)
{
    Size *= 1.2;

    vector<pair<float, float> > PointList;
    PointList.push_back(make_pair(X, Y - Size));
    PointList.push_back(make_pair(X - Size, Y));
    PointList.push_back(make_pair(X, Y + Size));
    PointList.push_back(make_pair(X + Size, Y));

    _ImageArea->DrawPolygon(PointList);
}



TKinokoCanvasImageMarker::TKinokoCanvasImageMarker(const string& ImageFileName)
{
    _ImageFileName = ImageFileName;

    _Image = 0;
    _HalfWidth = 0;
    _HalfHeight = 0;
}

TKinokoCanvasImageMarker::~TKinokoCanvasImageMarker()
{
}

TKinokoCanvasMarker* TKinokoCanvasImageMarker::Clone(const string& Parameter)
{
    if (! Parameter.empty()) {
	return new TKinokoCanvasImageMarker(Parameter);
    }
    else {
	return new TKinokoCanvasImageMarker(_ImageFileName);
    }
}

void TKinokoCanvasImageMarker::Draw(TKinokoCanvasImageArea* ImageArea, float X, float Y, float Size)
{
    if (_Image == 0) {
	_Image = ImageArea->LoadImage(_ImageFileName);
	if (_Image != 0) {
	    _HalfWidth = _Image->Width() / 2;
	    _HalfHeight = _Image->Height() / 2;
	}
    }
    else {
	//...
    }

    if (_Image != 0) {
	ImageArea->DrawImage(X - _HalfWidth, Y - _HalfHeight, _Image);
    }
}
