/* KinokoCanvasPlotObject.hh */
/* Created by Enomoto Sanshiro on 11 July 2000. */
/* Last updated by Enomoto Sanshiro on 23 January 2008. */


#ifndef __KinokoCanvasPlotObject_hh
#define __KinokoCanvasPlotObject_hh


#include <string>
#include <iostream>
#include "KinokoCanvasDataScale.hh"
#include "KinokoCanvasColorScale.hh"
#include "KinokoCanvasFramedObject.hh"


class TKinokoCanvasPlotObject: virtual public TKinokoCanvasFramedObject {
  public:
    TKinokoCanvasPlotObject(TKinokoCanvas* Canvas);
    virtual ~TKinokoCanvasPlotObject();
    virtual TKinokoShellObject* Clone(void);
    virtual void Initialize(void);
    virtual void Clear(void);
    virtual std::vector<std::string> ActionList(void);
    virtual int ProcessAction(const std::string& ActionName);
    virtual int ProcessRangeSelect(int X0, int Y0, int X1, int Y1);
  protected:
    virtual int ProcessCommand(const std::string& Command, std::istream& InputStream);
    virtual int ProcessSetCommand(const std::string& Name, const std::string& Value);
    virtual int ProcessDrawingAction(const std::string& ActionName);
    virtual int ProcessDrawingCommand(const std::string& Command, std::istream& InputStream);
    virtual int ProcessPlotCommand(std::istream& InputStream, int Style = 0);
    virtual int ProcessErrorPlotCommand(std::istream& InputStream);
    virtual int ProcessMinmaxPlotCommand(std::istream& InputStream);
    virtual int ProcessHistCommand(std::istream& InputStream, int Style = 0);
    virtual int ProcessBandHistCommand(std::istream& InputStream, int Style = 0);
    virtual int ProcessCommentCommand(std::istream& InputStream);
    virtual int ProcessDrawGridCommand(std::istream& InputStream, int AxisIndex);
    virtual int ProcessDrawXScaleLabelCommand(std::istream& InputStream);
    virtual int ProcessDrawYScaleLabelCommand(std::istream& InputStream);
    virtual int ProcessSetXScaleTimeTickCommand(std::istream& InputStream);
    virtual int ProcessSetXScaleElapseTickCommand(std::istream& InputStream);
    virtual int ProcessSetY2AxisCommand(std::istream& InputStream);
  public:
    virtual float CanvasXOf(float x);
    virtual float CanvasYOf(float y);
    virtual float CanvasY2Of(float y);
    virtual float XOf(float CanvasX);
    virtual float YOf(float CanvasY);
    virtual float Y2Of(float CanvasY);
  protected:
    virtual int SetCoordinate(float XMin, float YMin, float XWidth, float YWidth);
    virtual int SetY2Axis(float YMin, float YWidth, const std::string& Title);
    virtual int SetXScaleLinear(void);
    virtual int SetXScaleLog(void);
    virtual int SetXScaleTime(long Epoch, const std::string& Format, int Unit, int Step);
    virtual int SetXScaleElapse(void);
    virtual int SetYScaleLinear(void);
    virtual int SetYScaleLog(void);
  protected:
    virtual int DrawFrame(void);
    virtual void AddReplayCommand(const std::string& Command, const std::string& Parameter);
    virtual void ClearReplayCommandList(void);
    virtual void ReplayCommand(void);
  protected:
    TKinokoCanvasDataScale *_XScale, *_YScale;
    int _NumberOfXScaleLabels, _NumberOfYScaleLabels;
    bool _IsXScaleLabelDisabled, _IsYScaleLabelDisabled;
    bool _IsXScaleLog, _IsYScaleLog;
    bool _IsUpdatingSuspended, _IsCommentDisabled;
    int _CommentBoxColorIndex;
    float _LogXMin, _LogXMax, _LogYMin, _LogYMax;
    float _LogXWidth, _LogYWidth;
    float _XMinOrg, _XWidthOrg, _YMinOrg, _YWidthOrg;
    std::string _XTitle, _YTitle;
    bool _IsYTitleVertical, _IsScaleFactoringEnabled;
  protected:
    bool _IsCommandReplayEnabled;
    bool _IsCommandReplaySuspended;
    std::vector<std::pair<std::string, std::string> > _ReplayCommandList;
  private:
    enum TStyle {
	Style_None = 0x0000,
	Style_Points = 0x0001,
	Style_Lines = 0x0002,
	Style_Filled = 0x0004
    };
    enum TAxis {
	Axis_X,
	Axis_Y,
	Axis_Z
    };
#if 1
    //... temporary 
    float _Y2Min, _Y2Max, _Y2Width;
    float _LogY2Min, _LogY2Max, _LogY2Width;
    TKinokoCanvasDataScale* _Y2Scale;
    std::string _Y2Title;
#endif
};


class TKinokoCanvasMapPlotObject: public TKinokoCanvasColorScaledObject {
  public:
    TKinokoCanvasMapPlotObject(TKinokoCanvas* Canvas);
    virtual ~TKinokoCanvasMapPlotObject();
    virtual TKinokoShellObject* Clone(void);
    virtual void Initialize(void);
  protected:
    virtual float CanvasXOf(float x);
    virtual float CanvasYOf(float y);
  protected:
    virtual int ProcessCommand(const std::string& Command, std::istream& InputStream);
    virtual int ProcessPlotCommand(std::istream& InputStream);    
  protected:
    virtual int DrawFrame(void);
};


#endif

