/* KinokoCanvasSchematicObject.hh */
/* Created by Enomoto Sanshiro on 24 September. */
/* Last updated by Enomoto Sanshiro on 24 September. */


#ifndef __KinokoCanvasSchematicObject_hh
#define __KinokoCanvasSchematicObject_hh


#include <iostream>
#include <string>
#include <map>
#include "KinokoCanvasPictureObject.hh"
#include "KinokoCanvasColorScale.hh"


class TKinokoCanvasSchematicItem;
class TKinokoCanvasSchematicScale;
class TKinokoCanvasSchematicScaleTable;


class TKinokoCanvasSchematicObject: public TKinokoCanvasPictureObject {
  public:
    TKinokoCanvasSchematicObject(TKinokoCanvas* Canvas);
    virtual ~TKinokoCanvasSchematicObject();
    virtual TKinokoShellObject* Clone(void);
    virtual void Initialize(void);
    virtual int ProcessRangeSelect(int X0, int Y0, int X1, int Y1);
  public:
    virtual TKinokoCanvasImageArea* GetImageArea(void);
    virtual TKinokoCanvasSchematicScale* GetScale(const std::string& Name);
  protected:
    virtual int ProcessCommand(const std::string& Command, std::istream& InputStream);
    virtual int ProcessCreateScaleCommand(std::istream& InputStream);
    virtual int ProcessCreateItemCommand(std::istream& InputStream);
    virtual int ProcessSetValueCommand(std::istream& InputStream);
  protected:
    std::map<std::string, TKinokoCanvasSchematicScale*> _ScaleTable;
    std::map<int, TKinokoCanvasSchematicItem*> _ItemTable;
    std::map<std::string, TKinokoCanvasSchematicItem*> _ItemPrototypeTable;
};


class TKinokoCanvasSchematicScale: public TKinokoCanvasColorScale {
  public:
    TKinokoCanvasSchematicScale(double Min, double Max, TKinokoCanvasColorScale* ColorScale);
    virtual ~TKinokoCanvasSchematicScale();
    virtual int ColorIndexOf(double Value);
    virtual void Initialize(void);
  protected:
    virtual void CreateColorTable(void) {}
  protected:
    double _Min, _Max;
    TKinokoCanvasColorScale* _ColorScale;
};


class TKinokoCanvasSchematicItem {
  public:
    TKinokoCanvasSchematicItem(void);
    virtual ~TKinokoCanvasSchematicItem();
    virtual void Attach(TKinokoCanvasSchematicObject* SchematicObject);
    virtual TKinokoCanvasSchematicItem* Clone(void) = 0;
    virtual int Construct(std::istream& InputStream) = 0;
    virtual int SetValue(std::istream& InputStream) = 0;
    virtual bool Includes(int X, int Y) = 0;
  protected:
    inline float CanvasXOf(float x);
    inline float CanvasYOf(float y);
  protected:
    TKinokoCanvasSchematicObject* _SchematicObject;
    TKinokoCanvasImageArea* _ImageArea;
};


class TKinokoCanvasSchematicTextItem: public TKinokoCanvasSchematicItem {
  public:
    TKinokoCanvasSchematicTextItem(void);
    virtual ~TKinokoCanvasSchematicTextItem();
    virtual TKinokoCanvasSchematicItem* Clone(void);
    virtual int Construct(std::istream& InputStream);
    virtual int SetValue(std::istream& InputStream);
    virtual bool Includes(int X, int Y);
  protected:
    float _X0, _Y0, _X1, _Y1;
    std::string _Format;
    int _Color;
  private:
    int _BufferSize;
    char* _Buffer;
};


class TKinokoCanvasSchematicRectangleItem: public TKinokoCanvasSchematicItem {
  public:
    TKinokoCanvasSchematicRectangleItem(void);
    virtual ~TKinokoCanvasSchematicRectangleItem();
    virtual TKinokoCanvasSchematicItem* Clone(void);
    virtual int Construct(std::istream& InputStream);
    virtual int SetValue(std::istream& InputStream);
    virtual bool Includes(int X, int Y);
  protected:
    float _X0, _Y0, _X1, _Y1;
    TKinokoCanvasSchematicScale* _Scale;
};


class TKinokoCanvasSchematicCircleItem: public TKinokoCanvasSchematicItem {
  public:
    TKinokoCanvasSchematicCircleItem(void);
    virtual ~TKinokoCanvasSchematicCircleItem();
    virtual TKinokoCanvasSchematicItem* Clone(void);
    virtual int Construct(std::istream& InputStream);
    virtual int SetValue(std::istream& InputStream);
    virtual bool Includes(int X, int Y);
  protected:
    float _X0, _Y0, _Rx, _Ry;
    TKinokoCanvasSchematicScale* _Scale;
};



inline float TKinokoCanvasSchematicItem::CanvasXOf(float x)
{
    return _SchematicObject->CanvasXOf(x);
}

inline float TKinokoCanvasSchematicItem::CanvasYOf(float y)
{
    return _SchematicObject->CanvasYOf(y);
}


#endif
