/* KinokoCanvasTextArea.hh */
/* Created by Enomoto Sanshiro on 10 July 2000. */
/* Last updated by Enomoto Sanshiro on 10 July 2000. */


#ifndef __KinokoCanvasTextArea_hh
#define __KinokoCanvasTextArea_hh


#include <string>
#include <map>


class TKinokoCanvasTextArea {
  public:
    TKinokoCanvasTextArea(void);
    virtual ~TKinokoCanvasTextArea();
    virtual void Redraw(void) {}
    virtual void Clear(void) = 0;
    virtual void PutLine(const std::string& Line) = 0;
    virtual int AllocateColor(float Red, float Green, float Blue) = 0;
    virtual int SetTextColor(int ColorIndex) = 0;
    virtual int SetTextColorByName(const std::string& ColorName);
    virtual int LoadFont(const std::string& FontName) = 0;
    virtual int SetFont(int FontIndex) = 0;
    virtual int SetFontByName(const std::string& FontName);
  public:
    virtual void SetEditable(bool IsEditable) = 0;
    virtual void ScrollToTop(void) = 0;
    virtual void ScrollToBottom(void) = 0;
    virtual void FreezeScrolling(void) = 0;
    virtual void ThawScrolling(void) = 0;
  protected:
    virtual void AllocatePredefinedColors(void);
    virtual void LoadPredefinedFonts(void);
  protected:
    std::map<std::string, int> _PredefinedColorIndexTable;
    std::map<std::string, int> _PredefinedFontIndexTable;
    int _CurrentColorIndex;
    int _CurrentFontIndex;
};


#endif
