/* KinokoCanvasTypesetter.hh */
/* Created by Enomoto Sanshiro on 16 November 2003. */
/* Last updated by Enomoto Sanshiro on 16 November 2003. */


#ifndef __KinokoCanvasTypesetter_hh
#define __KinokoCanvasTypesetter_hh


#include <string>
#include <vector>
#include "KinokoCanvasImageArea.hh"


class TKinokoCanvasTextComposition {
  public:
    TKinokoCanvasTextComposition(void);
    ~TKinokoCanvasTextComposition();
    void Initialize(void);
    void Add(const std::string& String, int FontId, float X, float Y, float Width, float Height, float Ascent);
    float Width(void) const { return _Width; }
    float Height(void) const { return _Ascent + _Descent; }
    float Ascent(void) const { return _Ascent; }
    float Descent(void) const { return _Descent; }
    unsigned NumberOfElements(void) const { return _StringList.size(); }
    const std::string& StringOf(int Index) const { return _StringList[Index]; }
    int FontIdOf(int Index) const { return _FontIdList[Index]; }
    float PositionXOf(int Index) const { return _PositionList[Index].first; }
    float PositionYOf(int Index) const { return _PositionList[Index].second; }
    float WidthOf(int Index) const { return _WidthList[Index]; }
    float HeightOf(int Index) const { return _HeightList[Index]; }
    float AscentOf(int Index) const { return _AscentList[Index]; }
  protected:
    std::vector<std::string> _StringList;
    std::vector<int> _FontIdList;
    std::vector<std::pair<float, float> > _PositionList;
    std::vector<float> _WidthList;
    std::vector<float> _HeightList;
    std::vector<float> _AscentList;
    float _Width, _Ascent, _Descent;
};


class TKinokoCanvasTypesetter {
  public:
    TKinokoCanvasTypesetter(TKinokoCanvasImageArea* ImageArea);
    virtual ~TKinokoCanvasTypesetter();
    virtual void Typeset(float x, float y, const TKinokoCanvasTextComposition& Composition, const std::string& TextAdjustment = "");
    virtual std::string SetTextAdjustment(const std::string& Adjustment);
    virtual int SetTextOrientation(int Angle);
  protected:
    enum TTextAdjustment {
	TextAdjustment_Top, 
	TextAdjustment_Bottom, 
	TextAdjustment_Left, 
	TextAdjustment_Right, 
	TextAdjustment_Center
    };
  protected:
    TKinokoCanvasImageArea* _ImageArea;
    int _HorizontalTextAdjustment, _VerticalTextAdjustment;
    std::string _TextAdjustment;
    int _TextOrientation;
};


class TKinokoCanvasMathTextComposer {
  public:
    TKinokoCanvasMathTextComposer(TKinokoCanvasImageArea* ImageArea);
    TKinokoCanvasMathTextComposer(const TKinokoCanvasMathTextComposer& Composer);
    virtual ~TKinokoCanvasMathTextComposer();
    virtual void SetFont(const std::string& FontName, int FontSize);
    virtual const TKinokoCanvasTextComposition& Compose(const std::string& Text);
    virtual const TKinokoCanvasTextComposition& ComposeNumber(double Value);
    static std::string PowerOf10TextOf(double Value);
  protected:
    int FontSizeOf(int SubscriptionLevel);
    void Parse(TKinokoCanvasTextComposition& Composition);
    void ComposeThis(TKinokoCanvasTextComposition& Composition);
    void ParseSubscription(TKinokoCanvasTextComposition& Composition);
    void ParseSuperscription(TKinokoCanvasTextComposition& Composition);
    void ParseSymbol(TKinokoCanvasTextComposition& Composition);
  protected:
    enum TFontSize {
	FontSize_Normal,
	FontSize_Small,
	FontSize_Tiny,
	_NumberOfFontSizes
    };
  protected:
    TKinokoCanvasImageArea* _ImageArea;
    int _FontIdList[_NumberOfFontSizes];
    int _SymbolFontIdList[_NumberOfFontSizes];
    float _TextHeightList[_NumberOfFontSizes];
  private:
    const char* _Text;
    size_t _TextLength;
    unsigned _CurrentIndex;
    float _CurrentX, _CurrentY;
    int _CurrentFontId;
    int _CurrentSubscriptionLevel;
    std::string _CurrentString;
  private:
    TKinokoCanvasTextComposition _Composition;
};


#endif
