/* KinokoControl.hh */
/* Created by Enomoto Sanshiro on 1 October 2001. */
/* Last updated by Enomoto Sanshiro on 27 March 2002. */


#ifndef __KinokoControl_hh
#define __KinokoControl_hh


#include <string>
#include <vector>
#include <map>
#include <set>
#include "KinokoShell.hh"
#include "KinokoShellScript.hh"
#include "KinokoControlWidget.hh"
#include "KinokoControlPanel.hh"

class TKinokoControlScript;


class TKinokoControl: public TKinokoShell {
  public:
    TKinokoControl(TKinokoShellConnector* ShellConnector);
    virtual ~TKinokoControl();
    virtual void Start(void) = 0;
    virtual void Quit(void) = 0;
    virtual void HandleException(const TKinokoShellException& Exception) = 0;
    virtual void AddWidget(TKinokoControlWidget* Widget, const std::string& EnabledStateList = "");
    virtual void AddInputWidget(TKinokoControlWidget* Widget);
    virtual void AddImageWidget(TKinokoControlWidget* Widget);
    virtual void OnClickEvent(TKinokoControlWidget* Widget);
    virtual void OnFocusEvent(TKinokoControlWidget* Widget);
    virtual void OnBlurEvent(TKinokoControlWidget* Widget);
    virtual void LoadControlScript(std::istream& ScriptText, int LineNumberOffset = 0);
    virtual void RedrawImageWidgets(void);
  public:
    virtual void Construct(const std::string& ScriptFileName) = 0;
    virtual void InitializeWidgets(void);
    virtual int OnStartup(void);
    virtual int OnShutdown(void);
    virtual int OnEverySecond(void);
    virtual int Invoke(const std::string& MethodName, std::vector<std::string>& ArgumentList);
    virtual int UpdateWidgetValues(void);
    virtual int ChangeState(const std::string& StateName);
    virtual int SetWidgetValue(const std::string& WidgetName, const std::string& Value);
    virtual int SetWidgetAttribute(const std::string& WidgetName, const std::string& AttributeName, const std::string& Value);
    virtual int ClearWidgetValues(void);
    virtual int SaveWidgetValues(const std::string& FileName);
    virtual int LoadWidgetValues(const std::string& FileName);
    virtual const std::string& CurrentState(void);
    virtual TKinokoControlWidget* LookupWidget(const std::string& WidgetName);
  protected:
    virtual int ExecuteAction(const std::string& ActionName, std::vector<std::string>* ArgumentList = 0);
    virtual int ProcessSystemCommand(const std::string& Command, std::istream& InputStream);
    virtual int ProcessOpenControlPanelCommand(std::istream& InputStream);
    virtual int ProcessClearWidgetValuesCommand(std::istream& InputStream);
    virtual int ProcessSaveWidgetValuesCommand(std::istream& InputStream);
    virtual int ProcessLoadWidgetValuesCommand(std::istream& InputStream);
    virtual int ProcessSetWidgetValueCommand(std::istream& InputStream);
    virtual int ProcessSetWidgetAttributeCommand(std::istream& InputStream);
    virtual int ProcessExecuteActionCommand(std::istream& InputStream);
    virtual int ProcessLoadControlScriptCommand(std::istream& InputStream);
    virtual int ProcessChangeStateCommand(std::istream& InputStream);
    virtual int ProcessOpenPopupCommand(std::istream& InputStream, bool IsQuery);
    virtual std::string ReplaceEscape(const std::string& Value);
  protected:
    std::map<std::string, TKinokoControlWidget*> _WidgetTable; 
    std::vector<TKinokoControlWidget*> _WidgetList, _InputWidgetList; 
    std::vector<TKinokoControlWidget*> _ImageWidgetList; 
    std::vector<std::string> _InputValueCache;
    std::map<TKinokoControlWidget*, std::set<std::string> > _EnabledStateList;
    TKinokoControlScript* _Script;
    TKinokoShellScript* _ShellScript;
    std::string _CurrentState;
};


#endif
