/* KinokoControlPanel.cc */
/* Created by Enomoto Sanshiro on 27 September 2001. */
/* Last updated by Enomoto Sanshiro on 27 September 2001. */


#include <string>
#include "KinokoControl.hh"
#include "KinokoControlWidget.hh"
#include "KinokoControlPanel.hh"

using namespace std;



TKinokoControlPanel::TKinokoControlPanel(TKinokoControl* Control, const string& RootPath)
{
    _Control = Control;
    _RootPath = RootPath;
}

TKinokoControlPanel::~TKinokoControlPanel()
{
}

void TKinokoControlPanel::AddConstant(map<string, string>& OptionTable)
{
    string Name = OptionTable["name"];
    string Value = OptionTable["value"];
    
    TKinokoControlWidget* ControlWidget;
    ControlWidget = new TKinokoConstantWidget(Name, Value);

    _Control->AddWidget(ControlWidget);
    _Control->AddInputWidget(ControlWidget);
}

void TKinokoControlPanel::LoadControlScript(istream& ScriptText, int LineNumberOffset)
{
    _Control->LoadControlScript(ScriptText, LineNumberOffset);
}
