/* KinokoControlPanelScript.cc */
/* Created by Enomoto Sanshiro on 28 September 2001. */
/* Last updated by Enomoto Sanshiro on 1 August 2003. */


#include <iostream>
#include <sstream>
#include <string>
#include "KinokoControlPanel.hh"
#include "KinokoControlPanelScript.hh"


using namespace std;
using namespace mush;


TKinokoControlPanelScript::TKinokoControlPanelScript(TKinokoControlPanel* ControlPanel, const string& ScriptFileName)
{
    _ControlPanel = ControlPanel;
    _ScriptFileName = ScriptFileName;
    _ReadsCommentCharacter = false;
    
    _CurrentVisualWidget = 0;
}


TKinokoControlPanelScript::~TKinokoControlPanelScript()
{
}

void TKinokoControlPanelScript::OnStartWidget(const string& WidgetTypeName, map<string, string>& OptionTable)
{
    _TextStack.push_back(_CurrentText);
    _CurrentText.erase(_CurrentText.begin(), _CurrentText.end());
    _CurrentTextStartLineNumber = LineNumber();

    if (WidgetTypeName == "kinokocontrolpanel") {
	_ControlPanel->OpenPanel(OptionTable);
    }
    else if (WidgetTypeName == "frame") {
	_ControlPanel->OpenFrame(OptionTable);
    }
    else if (WidgetTypeName == "box") {
	_ControlPanel->OpenBox(OptionTable);
    }
    else if (WidgetTypeName == "notebook") {
	_ControlPanel->OpenNotebook(OptionTable);
    }
    else if (WidgetTypeName == "page") {
	_ControlPanel->OpenPage(OptionTable);
    }
    else if (WidgetTypeName == "table") {
	_ControlPanel->OpenTable(OptionTable);
    }
    else if (WidgetTypeName == "cell") {
	_ControlPanel->OpenCell(OptionTable);
    }
    else if (WidgetTypeName == "toolbar") {
	_ControlPanel->OpenToolBar(OptionTable);
    }
    else if (WidgetTypeName == "entrylist") {
	_ControlPanel->OpenEntryList(OptionTable);
    }
    else if (WidgetTypeName == "entry") {
	_ControlPanel->AddEntry(OptionTable);
    }
    else if (WidgetTypeName == "buttonlist") {
	_ControlPanel->OpenButtonList(OptionTable);
    }
    else if (WidgetTypeName == "button") {
	_ControlPanel->AddButton(OptionTable);
    }
    else if (WidgetTypeName == "checkbuttonlist") {
	_ControlPanel->OpenCheckButtonList(OptionTable);
    }
    else if (WidgetTypeName == "checkbutton") {
	_ControlPanel->AddCheckButton(OptionTable);
    }
    else if (WidgetTypeName == "radiobuttonlist") {
	_ControlPanel->OpenRadioButtonList(OptionTable);
    }
    else if (WidgetTypeName == "radiobutton") {
	_ControlPanel->AddRadioButton(OptionTable);
    }
    else if (WidgetTypeName == "menu") {
	_ControlPanel->OpenMenu(OptionTable);
    }
    else if (WidgetTypeName == "menuitem") {
	_ControlPanel->AddMenuItem(OptionTable);
    }
    else if (WidgetTypeName == "label") {
	_ControlPanel->AddLabel(OptionTable);
    }
    else if (WidgetTypeName == "textbox") {
	_ControlPanel->AddTextBox(OptionTable);
    }
    else if (WidgetTypeName == "image") {
	_ControlPanel->AddImage(OptionTable);
    }
    else if (WidgetTypeName == "newline") {
	_ControlPanel->AddNewLine(OptionTable);
    }
    else if (WidgetTypeName == "vspace") {
	_ControlPanel->AddVSpace(OptionTable);
    }
    else if (WidgetTypeName == "hspace") {
	_ControlPanel->AddHSpace(OptionTable);
    }
    else if (WidgetTypeName == "script") {
	_ReadsCommentCharacter = true;
    }
    else if (WidgetTypeName == "constant") {
	_ControlPanel->AddConstant(OptionTable);
    }
    else if (WidgetTypeName == "canvas") {
	_ControlPanel->AddViewlet(WidgetTypeName, OptionTable);
    }
    else if (WidgetTypeName == "plot") {
	_ControlPanel->AddViewlet(WidgetTypeName, OptionTable);
    }
    else {
	TKinokoControlVisualWidgetCreator* Creator = (
	    TKinokoControlVisualWidgetTable::GetInstance()->FindWidgetCreator(
		WidgetTypeName
	    )
	);
	if (Creator != 0) {
	    _CurrentVisualWidget = (
		_ControlPanel->AddVisualWidget(Creator, OptionTable)
	    );
	    _CurrentVisualWidgetName = WidgetTypeName;
	}
	else if (_CurrentVisualWidget != 0) {
	    _CurrentVisualWidget->AddDecoration(WidgetTypeName, OptionTable);
	}
    }
}

void TKinokoControlPanelScript::OnEndWidget(const string& WidgetTypeName)
{
    if (WidgetTypeName == "kinokocontrolpanel") {
	_ControlPanel->ClosePanel();
    }
    else if (WidgetTypeName == "frame") {
	_ControlPanel->CloseFrame();
    }
    else if (WidgetTypeName == "box") {
	_ControlPanel->CloseBox();
    }
    else if (WidgetTypeName == "notebook") {
	_ControlPanel->CloseNotebook();
    }
    else if (WidgetTypeName == "page") {
	_ControlPanel->ClosePage();
    }
    else if (WidgetTypeName == "table") {
	_ControlPanel->CloseTable();
    }
    else if (WidgetTypeName == "cell") {
	_ControlPanel->CloseCell();
    }
    else if (WidgetTypeName == "toolbar") {
	_ControlPanel->CloseToolBar();
    }
    else if (WidgetTypeName == "entrylist") {
	_ControlPanel->CloseEntryList();
    }
    else if (WidgetTypeName == "buttonlist") {
	_ControlPanel->CloseButtonList();
    }
    else if (WidgetTypeName == "checkbuttonlist") {
	_ControlPanel->CloseCheckButtonList();
    }
    else if (WidgetTypeName == "radiobuttonlist") {
	_ControlPanel->CloseRadioButtonList();
    }
    else if (WidgetTypeName == "menu") {
	_ControlPanel->CloseMenu();
    }
    else if (WidgetTypeName == "script") {
	istringstream ScriptText(_CurrentText);
	_ControlPanel->LoadControlScript(
	    ScriptText, _CurrentTextStartLineNumber
	);
	_ReadsCommentCharacter = false;
    }
    else if (WidgetTypeName == _CurrentVisualWidgetName) {
	_CurrentVisualWidget = 0;
    }

    if (! _TextStack.empty()) {
	_CurrentText = _TextStack.back();
	_TextStack.pop_back();
    }
}

void TKinokoControlPanelScript::OnText(const string& Text)
{
    _CurrentText += Text;
}

void TKinokoControlPanelScript::OnCommentText(const string& Text)
{
    if (_ReadsCommentCharacter) {
	_CurrentText += Text;
    }
}

void TKinokoControlPanelScript::OnScriptError(const string& Message, int LineNumber)
{
    cerr << "ERROR: ";
    if (LineNumber > 0) {
	cerr << "line " << LineNumber << ": ";
    }
    cerr << Message << endl;
}



TKinokoXmlControlPanelScript::TKinokoXmlControlPanelScript(TKinokoControlPanel* ControlPanel, const string& ScriptFileName)
: TKinokoControlPanelScript(ControlPanel, ScriptFileName)
{
    _Parser = new sax::Parser();
    _Parser->setDocumentHandler(this);
}

TKinokoXmlControlPanelScript::~TKinokoXmlControlPanelScript()
{
    delete _Parser;
}

void TKinokoXmlControlPanelScript::Go(void)
{
    try {
	_Parser->parse(_ScriptFileName);
    }
    catch (TSystemCallException &e) {
	OnScriptError(e.Message());
    }
}

long TKinokoXmlControlPanelScript::LineNumber(void)
{
    return _Locator->getLineNumber();
}

void TKinokoXmlControlPanelScript::startElement(const std::string& name, const sax::AttributeList& attribute_list)
{
    string WidgetTypeName;
    for (unsigned i = 0; i < name.size(); i++) {
	WidgetTypeName += tolower(name[i]);
    }

    map<string, string> OptionTable;
    for (unsigned i = 0; i < attribute_list.getLength(); i ++) {
	OptionTable[attribute_list.getName(i)] = attribute_list.getValue(i);
    }

    OnStartWidget(WidgetTypeName, OptionTable);
}

void TKinokoXmlControlPanelScript::endElement(const std::string& name)
{
    string WidgetTypeName;
    for (unsigned i = 0; i < name.size(); i++) {
	WidgetTypeName += tolower(name[i]);
    }

    OnEndWidget(WidgetTypeName);
}

void TKinokoXmlControlPanelScript::characters(const std::string& text)
{
    OnText(text);
}

void TKinokoXmlControlPanelScript::comment(const std::string& comment)
{
    OnCommentText(comment);
}

void TKinokoXmlControlPanelScript::warning(const std::string& message)
{
    OnScriptError("(warning) " + message, LineNumber());
}

void TKinokoXmlControlPanelScript::error(const std::string& message)
{
    OnScriptError(message, LineNumber());
}

void TKinokoXmlControlPanelScript::fatalError(const std::string& message)
{
    OnScriptError("fatal: " + message, LineNumber());
}

void TKinokoXmlControlPanelScript::setDocumentLocator(mush::sax::Locator* locator)
{
    _Locator = locator;
}
