/* KinokoControlScript.hh */
/* Created by Enomoto Sanshiro on 25 October 2002. */
/* Last updated by Enomoto Sanshiro on 25 September 2005. */


#ifndef __KinokoControlScript_hh__
#define __KinokoControlScript_hh__


#include <string>
#include <vector>
#include <map>
#include <list>
#include "KiscScript.hh"
#include "KinokoControl.hh"


class TKinokoControlDelayedTask;

class TKinokoControlScript: public TKiscScript {
  public:
    TKinokoControlScript(TKinokoControl* Control);
    virtual ~TKinokoControlScript();
    virtual void AddEventTask(const std::string& Name, TParaPackageEntry* Task);
    virtual void AddTransitionTask(const std::string& State, const std::string& NewState, TParaPackageEntry* Task);
    virtual void AddInvocationTask(const std::string& Name, TParaPackageEntry* Task);
    virtual void AddPeriodicTask(long Interval, TParaPackageEntry* Task);
    virtual void AddDelayedTask(long ExecutionTime, TKinokoControlDelayedTask* Task);
    virtual int ExecuteEventTask(const std::string& Name, std::vector<TParaValue*> ArgumentList) throw(TScriptException);
    virtual int ExecuteTransitionTask(const std::string& CurrentState, const std::string& NextState) throw(TScriptException);
    virtual int ExecuteInvocationTask(const std::string& Name) throw(TScriptException);
    virtual int ExecuteScheduledTask(long PresentTime) throw(TScriptException);
  protected:
    virtual TParaObjectPrototypeTable* CreateObjectPrototypeTable(void);
    virtual TParaBuiltinFunctionTable* CreateBuiltinFunctionTable(void);
    virtual TParaTokenTable* CreateTokenTable(void);
    virtual TParaOperatorTable* CreateOperatorTable(void);
    virtual TParaStatementTable* CreateStatementTable(void);
    virtual TParaPackage* CreatePackage(void);
  protected:
    TKinokoControl* _Control;
  protected:
    std::multimap<std::string, TParaPackageEntry*> _EventTaskTable;
    std::multimap<std::string, TParaPackageEntry*> _TransitionTaskTable;
    std::multimap<std::string, TParaPackageEntry*> _InvocationTaskTable;
    std::vector<std::pair<long, TParaPackageEntry*> > _PeriodicTaskTable;
    std::vector<long> _NextExecutionTimeTable;
    std::list<std::pair<long, TKinokoControlDelayedTask*> > _DelayedTaskList;
};


class TKinokoControlWidgetMessenger: public TParaObjectPrototype {
  public:
    TKinokoControlWidgetMessenger(TKinokoControlWidget* ControlWidget);
    virtual ~TKinokoControlWidgetMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual void Destruct(void) throw(TScriptException);
    virtual int MethodIdOf(const std::string& MethodName);
    virtual int InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    int SetValue(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int GetValue(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int SetAttribute(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int GetAttribute(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int Enable(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int Disable(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    enum {
	MethodId_SetValue = TParaObjectPrototype::_NumberOfMethods,
	MethodId_GetValue,
	MethodId_SetAttribute,
	MethodId_GetAttribute,
	MethodId_Enable,
	MethodId_Disable,
	_NumberOfMethods
    };
  protected:
    TKinokoControlWidget* _ControlWidget;
};


class TKinokoControlPanelMessenger: public TParaObjectPrototype {
  public:
    TKinokoControlPanelMessenger(TKinokoControl* Control);
    virtual ~TKinokoControlPanelMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual void Destruct(void) throw(TScriptException);
    virtual int MethodIdOf(const std::string& MethodName);
    virtual int InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    int LookupWidget(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int CurrentState(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int ClearWidgetValues(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int LoadWidgetValues(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int SaveWidgetValues(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    enum {
	MethodId_LookupWidget = TParaObjectPrototype::_NumberOfMethods,
	MethodId_CurrentState,
	MethodId_ClearWidgetValues,
	MethodId_LoadWidgetValues,
	MethodId_SaveWidgetValues,
	_NumberOfMethods
    };
  protected:
    TKinokoControl* _Control;
    std::map<TKinokoControlWidget*, TKinokoControlWidgetMessenger*> _ControlWidgetMessengerPool;
};


class TKinokoControlWidgetAccessOperator: public TParaOperator {
  public:
    TKinokoControlWidgetAccessOperator(TKinokoControl* Control);
    virtual ~TKinokoControlWidgetAccessOperator();
    virtual TParaOperator* Clone(void) const;
    virtual std::string Symbol(void) const;
    virtual std::string Name(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaExpressionParser* ExpressionParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TParaValue& Evaluate(TParaValue& Left, TParaValue& Right, TParaSymbolTable* SymbolTable, TParaValue& Result) throw(TScriptException); 
  protected:
    std::string _WidgetName;
    TKinokoControl* _Control;
    TKinokoControlWidgetMessenger* _ControlWidgetMessenger;
};


class TKinokoControlInvokeStatement: public TParaStatement {
  public:
    TKinokoControlInvokeStatement(TKinokoControl* Control);
    virtual ~TKinokoControlInvokeStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKinokoControl* _Control; 
    std::string _MethodName;
    std::vector<TParaExpression*> _ArgumentExpressionList;
};


class TKinokoControlExitStatement: public TParaStatement {
  public:
    TKinokoControlExitStatement(TKinokoControl* Control);
    virtual ~TKinokoControlExitStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKinokoControl* _Control; 
    TParaStatementParser* _StatementParser;
};


class TKinokoControlTaskEntry: public TParaPackageEntry {
  public:
    TKinokoControlTaskEntry(TKinokoControlScript* Script);
    virtual ~TKinokoControlTaskEntry();
    virtual TParaPackageEntry* Clone(void);
    virtual bool HasEntryWordsOf(TParaTokenizer* Tokenizer);
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TParaValue Execute(const std::vector<TParaValue*>& ArgumentList, TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKinokoControlScript* _Script;
    TParaStatement* _Statement;
};


class TKinokoControlAfterStatement: public TParaStatement {
  public:
    TKinokoControlAfterStatement(TKinokoControlScript* Script, TKinokoControl* Control);
    virtual ~TKinokoControlAfterStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKinokoControlScript* _Script;
    TKinokoControl* _Control;
    TParaExpression* _TimeToExecutionExpression;
    std::vector<TParaExpression*> _ArgumentExpressionList;
    TKinokoControlDelayedTask* _DelayedTask;
    long _TimeUnit;
};


class TKinokoControlDelayedTask: public TParaFunctionCallNode {
  public:
    TKinokoControlDelayedTask(long FunctionId, std::vector<TParaExpression*>& ArgumentExpressionList);
    virtual ~TKinokoControlDelayedTask(void);
    virtual TKinokoControlDelayedTask* Duplicate(void) = 0;
    virtual void Destroy(void);
    virtual void DuplicateArguments(std::vector<TParaValue*>& ArgumentList);
    virtual void Execute(TParaSymbolTable* SymbolTable) throw(TScriptException) = 0;
};


class TKinokoControlDelayedFunctionCall: public TKinokoControlDelayedTask {
  public:
    TKinokoControlDelayedFunctionCall(long FunctionId, const std::string& MethodName, std::vector<TParaExpression*>& ArgumentExpressionList);
    virtual ~TKinokoControlDelayedFunctionCall(void);
    virtual TKinokoControlDelayedTask* Duplicate(void);
    virtual void Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    virtual void DumpThis(std::ostream &os) const;
  protected:
    std::string _FunctionName;
};


class TKinokoControlDelayedMethodInvocation: public TKinokoControlDelayedTask {
  public:
    TKinokoControlDelayedMethodInvocation(long FunctionId, const std::string& MethodName, std::vector<TParaExpression*>& ArgumentExpressionList, TKinokoControl* Control);
    virtual ~TKinokoControlDelayedMethodInvocation(void);
    virtual TKinokoControlDelayedTask* Duplicate(void);
    virtual void Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    virtual void DumpThis(std::ostream &os) const;
  protected:
    TKinokoControl* _Control; 
    std::string _MethodName;
    std::vector<TParaExpression*> _ArgumentExpressionList;
};


#endif
