/* KinokoControlViewletMessenger.hh */
/* Created by Enomoto Sanshiro on 12 August 2007. */
/* Last updated by Enomoto Sanshiro on 12 August 2007. */


#ifndef __KinokoControlViewletMessenger_hh__
#define __KinokoControlViewletMessenger_hh__


#include <string>
#include <vector>
#include "KiscScript.hh"
#include "KinokoControl.hh"
#include "KinokoControlScript.hh"


class TKinokoControlCanvasViewletMessenger: public TKinokoControlWidgetMessenger {
  public:
    TKinokoControlCanvasViewletMessenger(TKinokoControlCanvasViewlet* CanvasViewlet);
    virtual ~TKinokoControlCanvasViewletMessenger();
    virtual int MethodIdOf(const std::string& MethodName);
    virtual int InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    int Clear(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int DrawLine(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int DrawCircle(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int DrawText(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    enum {
	MethodId_Clear = TKinokoControlWidgetMessenger::_NumberOfMethods,
	MethodId_DrawLine,
	MethodId_DrawCircle,
	MethodId_DrawText,
	_NumberOfMethods
    };
  protected:
    TKinokoControlCanvasViewlet* _CanvasViewlet;
};


class TKinokoControlPlotViewletMessenger: public TKinokoControlWidgetMessenger {
  public:
    TKinokoControlPlotViewletMessenger(TKinokoControlPlotViewlet* PlotViewlet);
    virtual ~TKinokoControlPlotViewletMessenger();
    virtual int MethodIdOf(const std::string& MethodName);
    virtual int InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    int Clear(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int SetRange(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int ResetRange(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int GuessRange(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int SetColor(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int SetLineWidth(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int SetMarker(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int SetYScaleLog(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int SetTimeTick(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int Draw(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    enum {
	MethodId_Clear = TKinokoControlWidgetMessenger::_NumberOfMethods,
	MethodId_SetRange,
	MethodId_ResetRange,
	MethodId_GuessRange,
	MethodId_SetColor,
	MethodId_SetLineWidth,
	MethodId_SetMarker,
	MethodId_SetYScaleLog,
	MethodId_SetTimeTick,
	MethodId_Draw,
	_NumberOfMethods
    };
  protected:
    TKinokoControlPlotViewlet* _PlotViewlet;
};


#endif
