/* KinokoMonitor.hh */
/* Created by Enomoto Sanshiro on 16 May 2004. */
/* Last updated by Enomoto Sanshiro on 16 May 2004. */


#ifndef __KinokoMonitor_hh
#define __KinokoMonitor_hh


#include <string>
#include <vector>
#include <map>
#include "MushXml.hh"


class TKinokoMonitorComponentCondition {
  public:
    TKinokoMonitorComponentCondition(const std::string& Name);
    virtual ~TKinokoMonitorComponentCondition();
    virtual void Update(const std::string& CheckTime, const std::string& State, const std::string& HeartBeatCount);
    const std::string& Name(void) const { return _Name; }
    long CheckTime(void) const { return _CheckTime; }
    const std::string& State(void) const { return _State; }
    double HeartBeatCount(void) const { return _HeartBeatCount; }
  protected:
    std::string _Name;
    long _CheckTime;
    std::string _State;
    long _HeartBeatCount;
};


class TKinokoMonitorFileCondition {
  public:
    TKinokoMonitorFileCondition(const std::string& Name);
    virtual ~TKinokoMonitorFileCondition();
    virtual void Update(void);
    const std::string& Name(void) const { return _Name; }
    long CheckTime(void) const { return _CheckTime; }
    const std::string& FileSize(void) const { return _FileSizeString; }
    double GrowingSpeed(void) const { return _GrowingSpeed; }
  protected:
    std::string _Name;
    long _CheckTime;
    long _FileSize;
    long _GrowingSpeed;
    std::string _FileSizeString;
};


class TKinokoMonitor: public mush::sax::DocumentHandler {
  public:
    TKinokoMonitor(void);
    virtual ~TKinokoMonitor();
  protected:
    virtual void Update(const std::string& RegistryFileName);
  public:
    virtual void startElement(const std::string& name, const mush::sax::AttributeList& attribute_list);
    virtual void endElement(const std::string& name);
    virtual void characters(const std::string& text);
  protected:
    mush::sax::Parser* _Parser;
    std::vector<std::string> _ComponentNameList;
    std::vector<std::string> _FileNameList;
    std::map<std::string, TKinokoMonitorComponentCondition*> _ComponentList;
    std::map<std::string, TKinokoMonitorFileCondition*> _FileList;
    long _UpdateTime, _FileTime;
  private:
    std::map<std::string, std::string> _CurrentPropertyList;
    std::string _CurrentValue;
    int _Depth;
    enum { 
	State_Init,
	State_Root,
	State_ComponentList, 
	State_PropertyList, 
	State_Property,
	State_Monitor, 
	State_MonitorElement, 
	State_Others
    } _State;
};


#endif
