/* KinokoCanvasGtk.hh */
/* Created by Enomoto Sanshiro on 9 July 2000. */
/* Last updated by Enomoto Sanshiro on 1 October 2001. */


#ifndef __KinokoCanvasGtk_hh
#define __KinokoCanvasGtk_hh


#include <gtk/gtk.h>
#include "KinokoCanvas.hh"


class TKinokoCanvasGtk: public TKinokoCanvas {
  public:
    TKinokoCanvasGtk(TKinokoShellConnector* ShellConnector, int argc, char** argv, int Width = 800, int Height = 600, int Left = -1, int Top = -1, bool EnableEps = false);
    virtual ~TKinokoCanvasGtk();
    virtual void Start(void);
    virtual void Quit(void);
    virtual int SetTitle(const std::string& Title);
    virtual int OpenContextMenu(TKinokoCanvasObject* CanvasObject);
    virtual int CloseContextMenu(void);
    virtual int ProcessContextMenuAction(const char* ActionName);
  protected:
    virtual TKinokoShellPopupWindow* CreatePopupWindow(void);
    virtual TKinokoShellFileSelectDialog* CreateFileSelectDialog(void);
  protected:
    void BuildRootWindow(void);
  protected:
    int _Width, _Height, _Left, _Top;
    GtkWidget* _RootWindow;
    GtkWidget* _TextWidget;
    GtkWidget* _DrawingAreaWidget;
    TKinokoCanvasImageArea* _ImageArea;
    bool _IsEpsEnabled;
  protected:
    TKinokoCanvasObject* _CurrentContextMenuObject;
    GtkWidget* _CurrentContextMenu;
    std::vector<char*> _CurrentContextMenuActionNameList;
};


#endif
