/* KinokoCanvasImageAreaGtk.hh */
/* Created by Enomoto Sanshiro on 9 July 2000. */
/* Last updated by Enomoto Sanshiro on 12 April 2003. */


#ifndef __KinokoCanvasImagaAreaGtk_hh
#define __KinokoCanvasImageAreaGtk_hh


#include <string>
#include <vector>
#include <map>
#include <gtk/gtk.h>
#include "KinokoCanvasImageArea.hh"


class TKinokoCanvasImageAreaGtk: public TKinokoCanvasImageArea {
  public:
    TKinokoCanvasImageAreaGtk(GtkWidget* DrawingArea);
    virtual ~TKinokoCanvasImageAreaGtk();
    virtual void Redraw(void);
    virtual void Clear(void);
    virtual void ClearArea(float x0, float y0, float x1, float y1);
    virtual int SaveImageTo(const std::string& FileName);
  public:
    virtual void DrawPoint(float x, float y);
    virtual void DrawLine(float x0, float y0, float x1, float y1);
    virtual void DrawRect(float x0, float y0, float x1, float y1);
    virtual void DrawRectFill(float x0, float y0, float x1, float y1);
    virtual void DrawLines(const std::vector<std::pair<float, float> >& PointList);
    virtual void DrawPolygon(const std::vector<std::pair<float, float> >& PointList);
    virtual void DrawPolygonFill(const std::vector<std::pair<float, float> >& PointList);
    virtual void DrawCircle(float x, float y, float radius);
    virtual void DrawCircleFill(float x, float y, float radius);
    virtual void DrawEllipse(float x, float y, float rx, float ry, float Angle = 0);
    virtual void DrawEllipseFill(float x, float y, float rx, float ry, float Angle = 0);
    virtual void DrawText(float x, float y, const std::string& Text, const std::string& Adjustment = "");
    virtual int AllocateColor(const std::string& ColorName);
    virtual int AllocateColorRgb(float Red, float Green, float Blue);
    virtual int SetColor(int ColorIndex);
    virtual int SetBackgroundColor(int ColorIndex);
    virtual bool GetColor(int ColorIndex, TKinokoCanvasColor& Color);
    virtual int SetLineWidth(int LineWidth);
    virtual int CreateLineStyle(const std::string& LineStyleName);
    virtual int CreateLineStyleFromPattern(const std::string& LineStylePattern);
    virtual int SetLineStyle(int LineStyleIndex = 0, unsigned Offset = 0);
    virtual bool GetLineStyle(int LineStyleIndex, std::vector<int>& LineStyle);
    virtual int SetDrawingFunction(int FunctionId);
    virtual int LoadFont(const std::string& FontName, int FontSize);
    virtual int LoadSystemFont(const std::string& FontName);
    virtual int SetFont(int FontIndex);
    virtual std::string SetTextAdjustment(const std::string& Adjustment);
    virtual int SetTextOrientation(int Degree);
    virtual TKinokoCanvasImage* LoadXpmImage(const std::string& FileName);
    virtual void DrawImage(float x, float y, TKinokoCanvasImage* Image);
  public:
    virtual int TextHeightOf(const std::string& Text);
    virtual int TextAscentOf(const std::string& Text);
    virtual int TextWidthOf(const std::string& Text);
  protected:
    GdkPoint* GdkPointList(const std::vector<std::pair<float, float> >& PointList);
    void DrawTextRotated(float x, float y, const std::string& Text, int Degree);
  protected:
    GtkWidget* _DrawingArea;
    GdkDrawable* _Drawable;
    GdkGC* _BlackGC;
    GdkGC* _WhiteGC;
    GdkGC* _DoubleBufferGC;
  protected:
    int _CurrentColorIndex, _CurrentBackgroundColorIndex;
    int _CurrentLineWidth;
    int _CurrentLineStyleIndex;
    int _CurrentDrawingFunction;
    int _CurrentFontIndex;
    std::string _CurrentTextAdjustment;
    int _CurrentTextOrientation;
  protected:
    GdkFont* _CurrentFont; 
    GdkLineStyle _CurrentLineSolidness;
    unsigned _CurrentLineOffset;
    std::vector<GdkColor*> _ColorList;
    std::vector<std::pair<signed char*, int> > _LineStyleList;
    std::vector<GdkFont*> _FontList;
    TTextAdjustment _VerticalTextAdjustment;
    TTextAdjustment _HorizontalTextAdjustment;
    std::vector<TKinokoCanvasImage*> _ImageList;
    std::vector<std::pair<GdkPixmap*, GdkBitmap*> > _PixmapList;
  protected:
    std::map<std::string, int> _PredefinedColorTable;
    std::map<std::string, int> _ColorCacheTable;
    std::map<std::string, std::string> _PredefinedFontNameTable;
    std::map<std::string, int> _PredefinedLineStyleTable;
  private:
    GdkPoint* _PointListBuffer;
    int _PointListBufferSize;
    std::map<std::string, int> _LineStyleCache;
    std::map<std::string, int> _FontCache;
    std::map<std::string, TKinokoCanvasImage*> _ImageCache;
};


#endif
