/* kinoko-splash-gtk.cc */
/* Created by Enomoto Sanshiro on 11 November 2000. */
/* Last updated by Enomoto Sanshiro on 11 November 2000. */


#include <fstream>
#include <string>
#include <gtk/gtk.h>
#include <MushArgumentList.hh>

using namespace std;


static gint quit_cb(void*);

int main(int argc, char** argv)
{
    gtk_init(&argc, &argv);
    TMushArgumentList ArgumentList(argc, argv);

    if (ArgumentList.NumberOfParameters() < 1) {
	cerr << "Usage: " << argv[0] << " XPM_FILE [--time=TIME_MS]" << endl;
	return 0;
    }

    int Time_ms;
    string XpmFileName = ArgumentList[0];
    try { 
	Time_ms = ArgumentList.IntOptionValueOf("--time");
    }
    catch (TSystemCallException& e) {
	Time_ms = 2000;
    }

    GtkWidget* Window = gtk_window_new(GTK_WINDOW_POPUP);
    gtk_window_set_position(GTK_WINDOW(Window), GTK_WIN_POS_CENTER);
    gtk_widget_realize(Window);

    GdkBitmap* Mask;
    GdkPixmap* PixmapData;
    PixmapData = gdk_pixmap_create_from_xpm(
	Window->window, &Mask, 0, XpmFileName.c_str()
    );
    if (PixmapData == NULL) {
	g_print(
	    ("unable to open xpm file: " + XpmFileName + "\n").c_str()
	);
	return -1;
    }

    GtkWidget* KinokoSplash = gtk_pixmap_new(PixmapData, Mask);
    gtk_container_add(GTK_CONTAINER(Window), KinokoSplash);
    gtk_widget_show_all(Window);

    gtk_timeout_add(Time_ms, quit_cb, 0);
    gtk_main();

    return 0;
}

static gint quit_cb(void*)
{
    gtk_main_quit();
    return 0;
}
