/* KinokoCanvasTextAreaGtk.cc */
/* Created by Enomoto Sanshiro on 9 July 2000. */
/* Last updated by Enomoto Sanshiro on 9 July 2000. */


#include <iostream>
#include <sstream>
#include <iomanip>
#include <gtk/gtk.h>
#include "KinokoCanvasTextAreaGtk.hh"

using namespace std;


TKinokoCanvasTextAreaGtk::TKinokoCanvasTextAreaGtk(GtkWidget* TextView)
{
    _TextView = TextView;
    _TextBuffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(_TextView));

    _ColorTagList.push_back(NULL);
    _FontTagList.push_back(NULL);

    _CurrentColorTag = _ColorTagList[0];
    _CurrentFontTag = _FontTagList[0];

    _IsScrollingFrozen = false;
}

TKinokoCanvasTextAreaGtk::~TKinokoCanvasTextAreaGtk()
{
}

void TKinokoCanvasTextAreaGtk::Clear(void)
{
    GtkTextIter Start, End;
    gtk_text_buffer_get_start_iter(_TextBuffer, &Start);
    gtk_text_buffer_get_end_iter(_TextBuffer, &End);

    gtk_text_buffer_delete(_TextBuffer, &Start, &End);
}

void TKinokoCanvasTextAreaGtk::PutLine(const string& Line)
{
    GtkTextIter Position;
    gtk_text_buffer_get_end_iter(_TextBuffer, &Position);

    if ((_CurrentColorTag != NULL) && (_CurrentFontTag != NULL)) {
	gtk_text_buffer_insert_with_tags(
	    _TextBuffer, &Position, Line.data(), Line.size(), 
	    _CurrentColorTag, _CurrentFontTag, NULL
	);
    }
    else if (_CurrentColorTag != NULL) {
	gtk_text_buffer_insert_with_tags(
	    _TextBuffer, &Position, Line.data(), Line.size(), 
	    _CurrentColorTag, NULL
	);
    }
    else if (_CurrentFontTag != NULL) {
	gtk_text_buffer_insert_with_tags(
	    _TextBuffer, &Position, Line.data(), Line.size(), 
	    _CurrentFontTag, NULL
	);
    }
    else {
	gtk_text_buffer_insert(
	    _TextBuffer, &Position, Line.data(), Line.size()
	);
    }

    if (! _IsScrollingFrozen) {
	gtk_text_view_scroll_to_iter(
	    GTK_TEXT_VIEW(_TextView), &Position, 0, FALSE, 0.0, 1.0
	);
    }
}

int TKinokoCanvasTextAreaGtk::AllocateColor(float Red, float Green, float Blue)
{
    ostringstream ColorName;
    ColorName << "#" << hex;
    ColorName << setw(4) << setfill('0') << ((int) (Red * 0xffff));
    ColorName << setw(4) << setfill('0') << ((int) (Green * 0xffff));
    ColorName << setw(4) << setfill('0') << ((int) (Blue * 0xffff));

    GtkTextTag* ColorTag = gtk_text_buffer_create_tag(
	_TextBuffer, NULL,
	"foreground", ColorName.str().c_str(), NULL
    );

    int ColorIndex = _ColorTagList.size();
    _ColorTagList.push_back(ColorTag);

    return ColorIndex;
}

int TKinokoCanvasTextAreaGtk::SetTextColor(int ColorIndex)
{
    if ((ColorIndex < 0) || (ColorIndex >= (int) _ColorTagList.size())) {
	return _CurrentColorIndex;
    }

    int OldColorIndex = _CurrentColorIndex;
    _CurrentColorTag = _ColorTagList[ColorIndex];
    _CurrentColorIndex = ColorIndex;

    return OldColorIndex;
}

int TKinokoCanvasTextAreaGtk::LoadFont(const std::string& FontName)
{
    GtkTextTag* FontTag = gtk_text_buffer_create_tag(
	_TextBuffer, NULL,
	"foreground", FontName.c_str(), NULL
    );

    int FontIndex = _FontTagList.size();
    _FontTagList.push_back(FontTag);

    return FontIndex;
}

int TKinokoCanvasTextAreaGtk::SetFont(int FontIndex)
{
    if ((FontIndex < 0) || (FontIndex >= (int) _FontTagList.size())) {
	return _CurrentFontIndex;
    }

    int OldFontIndex = _CurrentFontIndex;
    _CurrentFontTag = _FontTagList[FontIndex];
    _CurrentFontIndex = FontIndex;

    return OldFontIndex;
}

void TKinokoCanvasTextAreaGtk::SetEditable(bool IsEditable)
{
    if (IsEditable) {
	gtk_text_view_set_editable(GTK_TEXT_VIEW(_TextView), TRUE);
    }
    else {
	gtk_text_view_set_editable(GTK_TEXT_VIEW(_TextView), FALSE);
    }
}

void TKinokoCanvasTextAreaGtk::ScrollToTop(void)
{
    GtkTextIter Position;
    gtk_text_buffer_get_start_iter(_TextBuffer, &Position);

    gtk_text_view_scroll_to_iter(
	GTK_TEXT_VIEW(_TextView), &Position, 0, FALSE, 0.0, 1.0
    );
}

void TKinokoCanvasTextAreaGtk::ScrollToBottom(void)
{
    GtkTextIter Position;
    gtk_text_buffer_get_end_iter(_TextBuffer, &Position);

    gtk_text_view_scroll_to_iter(
	GTK_TEXT_VIEW(_TextView), &Position, 0, FALSE, 0.0, 1.0
    );
}

void TKinokoCanvasTextAreaGtk::FreezeScrolling(void)
{
    _IsScrollingFrozen = true;
}

void TKinokoCanvasTextAreaGtk::ThawScrolling(void)
{
    _IsScrollingFrozen = false;
}
