/* KinokoControlWidgetGtk.cc */
/* Created by Enomoto Sanshiro on 30 September 2001. */
/* Last updated by Enomoto Sanshiro on 30 September 2001. */


#include <iostream>
#include <sstream>
#include <string>
#include <vector>
#include <cstdlib>
#include <cstring>
#include <gtk/gtk.h>
#include "KinokoShellConfig.hh"
#include "KinokoCanvasImageAreaGtk.hh"
#include "KinokoCanvasImageAreaGtkPango.hh"
#include "KinokoControlWidget.hh"
#include "KinokoControlWidgetGtk.hh"

using namespace std;


TKinokoButtonWidgetGtk::TKinokoButtonWidgetGtk(const string& Name, GtkWidget* ButtonWidget, const std::string& ActionOnClick)
: TKinokoButtonWidget(Name, ActionOnClick)
{
    _ButtonWidget = ButtonWidget;
}

TKinokoButtonWidgetGtk::~TKinokoButtonWidgetGtk()
{
}

void TKinokoButtonWidgetGtk::Enable(void)
{
    TKinokoButtonWidget::Enable();
    gtk_widget_set_sensitive(GTK_WIDGET(_ButtonWidget), TRUE);
}

void TKinokoButtonWidgetGtk::Disable(void)
{
    gtk_widget_set_sensitive(GTK_WIDGET(_ButtonWidget), FALSE);
    TKinokoButtonWidget::Disable();
}



TKinokoLabelWidgetGtk::TKinokoLabelWidgetGtk(const string& Name, GtkWidget* LabelWidget)
: TKinokoLabelWidget(Name)
{
    _LabelWidget = LabelWidget;
}

TKinokoLabelWidgetGtk::~TKinokoLabelWidgetGtk()
{
}

string TKinokoLabelWidgetGtk::Value(void)
{
    return gtk_label_get_text(GTK_LABEL(_LabelWidget));
}

void TKinokoLabelWidgetGtk::SetValue(const string& Value)
{
    gtk_label_set_text(GTK_LABEL(_LabelWidget), Value.c_str());
}

void TKinokoLabelWidgetGtk::Enable(void)
{
    TKinokoLabelWidget::Enable();
}

void TKinokoLabelWidgetGtk::Disable(void)
{
    TKinokoLabelWidget::Disable();
}



static void FreeItem(gpointer Data, gpointer UserData)
{
    free(Data);
}

TKinokoEntryWidgetGtk::TKinokoEntryWidgetGtk(const string& Name, GtkWidget* EntryWidget, GtkWidget* ComboWidget, GList* ComboItemList)
: TKinokoEntryWidget(Name)
{
    _EntryWidget = EntryWidget;
    _ComboWidget = ComboWidget;
    _ComboItemList = ComboItemList;
}

TKinokoEntryWidgetGtk::~TKinokoEntryWidgetGtk()
{
    if (_ComboItemList != NULL) {
	g_list_foreach(_ComboItemList, FreeItem, 0);
	g_list_free(_ComboItemList);
    }
}

string TKinokoEntryWidgetGtk::Value(void)
{
    return gtk_entry_get_text(GTK_ENTRY(_EntryWidget));
}

void TKinokoEntryWidgetGtk::SetValue(const string& Value)
{
    gtk_entry_set_text(GTK_ENTRY(_EntryWidget), Value.c_str());
}

bool TKinokoEntryWidgetGtk::SetAttribute(const std::string& Name, const std::string& Value)
{
    bool Result = false;

    if ((Name == "selection") && (_ComboWidget != 0)) {
	if (_ComboItemList != NULL) {
	    g_list_foreach(_ComboItemList, FreeItem, 0);
	    g_list_free(_ComboItemList);
	    _ComboItemList = NULL;
	}

	string Item;
	istringstream SelectionStream(Value);
	while (SelectionStream >> Item) {
	    _ComboItemList = g_list_append(
		_ComboItemList, strdup(Item.c_str())
	    );
	}

	gtk_combo_set_popdown_strings(GTK_COMBO(_ComboWidget), _ComboItemList);
	Result = true;
    }

    return Result;
}

void TKinokoEntryWidgetGtk::Enable(void)
{
    TKinokoEntryWidget::Enable();
    gtk_entry_set_editable(GTK_ENTRY(_EntryWidget), TRUE);
    gtk_widget_set_sensitive(GTK_WIDGET(_EntryWidget), TRUE);
}

void TKinokoEntryWidgetGtk::Disable(void)
{
    gtk_entry_set_editable(GTK_ENTRY(_EntryWidget), FALSE);
    gtk_widget_set_sensitive(GTK_WIDGET(_EntryWidget), FALSE);
    TKinokoEntryWidget::Disable();
}



TKinokoTextBoxWidgetGtk::TKinokoTextBoxWidgetGtk(const string& Name, GtkWidget* TextWidget)
: TKinokoTextBoxWidget(Name)
{
    _TextWidget = TextWidget;
}

TKinokoTextBoxWidgetGtk::~TKinokoTextBoxWidgetGtk()
{
}

string TKinokoTextBoxWidgetGtk::Value(void)
{
    GtkTextBuffer* TextBuffer;
    GtkTextIter Start, End;
    TextBuffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(_TextWidget));
    gtk_text_buffer_get_start_iter(TextBuffer, &Start);
    gtk_text_buffer_get_end_iter(TextBuffer, &End);

    return string(gtk_text_buffer_get_text(TextBuffer, &Start, &End, FALSE));
}

void TKinokoTextBoxWidgetGtk::SetValue(const string& Value)
{
    GtkTextBuffer* TextBuffer;
    TextBuffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(_TextWidget));
    gtk_text_buffer_set_text(TextBuffer, Value.data(), Value.size());
}

void TKinokoTextBoxWidgetGtk::Enable(void)
{
    TKinokoTextBoxWidget::Enable();
    gtk_text_view_set_editable(GTK_TEXT_VIEW(_TextWidget), TRUE);
}

void TKinokoTextBoxWidgetGtk::Disable(void)
{
    gtk_text_view_set_editable(GTK_TEXT_VIEW(_TextWidget), FALSE);
    TKinokoTextBoxWidget::Disable();
}



TKinokoCheckButtonWidgetGtk::TKinokoCheckButtonWidgetGtk(const string& Name, GtkWidget* CheckButtonWidget)
: TKinokoCheckButtonWidget(Name)
{
    _CheckButtonWidget = CheckButtonWidget;
}

TKinokoCheckButtonWidgetGtk::~TKinokoCheckButtonWidgetGtk()
{
}

string TKinokoCheckButtonWidgetGtk::Value(void)
{
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(_CheckButtonWidget))) {
	return "1";
    }
    else {
	return "0";
    }
}

void TKinokoCheckButtonWidgetGtk::SetValue(const string& Value)
{
    gboolean State;
    if (Value.empty() || (Value == "0")) {
	State = FALSE;
    }
    else {
	State = TRUE;
    }

    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(_CheckButtonWidget), State);
}

void TKinokoCheckButtonWidgetGtk::Enable(void)
{
    TKinokoCheckButtonWidget::Enable();
    gtk_widget_set_sensitive(GTK_WIDGET(_CheckButtonWidget), TRUE);
}

void TKinokoCheckButtonWidgetGtk::Disable(void)
{
    gtk_widget_set_sensitive(GTK_WIDGET(_CheckButtonWidget), FALSE);
    TKinokoCheckButtonWidget::Disable();
}



TKinokoRadioButtonWidgetGtk::TKinokoRadioButtonWidgetGtk(const string& Name, GtkWidget* RadioButtonWidget)
: TKinokoRadioButtonWidget(Name)
{
    _RadioButtonWidget = RadioButtonWidget;
}

TKinokoRadioButtonWidgetGtk::~TKinokoRadioButtonWidgetGtk()
{
}

string TKinokoRadioButtonWidgetGtk::Value(void)
{
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(_RadioButtonWidget))) {
	return "1";
    }
    else {
	return "0";
    }
}

void TKinokoRadioButtonWidgetGtk::SetValue(const string& Value)
{
    gboolean State;
    if (Value.empty() || (Value == "0")) {
	State = FALSE;
    }
    else {
	State = TRUE;
    }

    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(_RadioButtonWidget), State);
}

void TKinokoRadioButtonWidgetGtk::Enable(void)
{
    TKinokoRadioButtonWidget::Enable();
    gtk_widget_set_sensitive(GTK_WIDGET(_RadioButtonWidget), TRUE);
}

void TKinokoRadioButtonWidgetGtk::Disable(void)
{
    gtk_widget_set_sensitive(GTK_WIDGET(_RadioButtonWidget), FALSE);
    TKinokoRadioButtonWidget::Disable();
}



TKinokoNotebookWidgetGtk::TKinokoNotebookWidgetGtk(const std::string& Name, GtkWidget* NotebookWidget)
: TKinokoNotebookWidget(Name)
{
    _NotebookWidget = NotebookWidget;
}

TKinokoNotebookWidgetGtk::~TKinokoNotebookWidgetGtk()
{
}

std::string TKinokoNotebookWidgetGtk::Value(void)
{
    int CurrentPage = gtk_notebook_get_current_page(
	GTK_NOTEBOOK(_NotebookWidget)
    );

    ostringstream os;
    os << CurrentPage;

    return os.str();
}

void TKinokoNotebookWidgetGtk::SetValue(const std::string& Value)
{
    int TargetPage;
    istringstream is(Value);
    if (is >> TargetPage) {
	gtk_notebook_set_current_page(
	    GTK_NOTEBOOK(_NotebookWidget), TargetPage
	);
    }
}



TKinokoMenuItemWidgetGtk::TKinokoMenuItemWidgetGtk(const string& Name, GtkWidget* MenuItemWidget, const std::string& ActionOnClick)
: TKinokoMenuItemWidget(Name, ActionOnClick)
{
    _MenuItemWidget = MenuItemWidget;
}

TKinokoMenuItemWidgetGtk::~TKinokoMenuItemWidgetGtk()
{
}

void TKinokoMenuItemWidgetGtk::Enable(void)
{
    TKinokoMenuItemWidget::Enable();
    gtk_widget_set_sensitive(GTK_WIDGET(_MenuItemWidget), TRUE);
}

void TKinokoMenuItemWidgetGtk::Disable(void)
{
    gtk_widget_set_sensitive(GTK_WIDGET(_MenuItemWidget), FALSE);
    TKinokoMenuItemWidget::Disable();
}



TKinokoControlImagePortGtk::TKinokoControlImagePortGtk(GtkWidget* DrawingAreaWidget)
{
    _DrawingAreaWidget = DrawingAreaWidget;
    _ImageArea = 0;
}

TKinokoControlImagePortGtk::~TKinokoControlImagePortGtk()
{
    delete _ImageArea;
}

void TKinokoControlImagePortGtk::Initialize(void)
{
    if (_ImageArea) {
	return;
    }

#if USE_PANGO
    _ImageArea = new TKinokoCanvasImageAreaGtkPango(_DrawingAreaWidget);
#else
    _ImageArea = new TKinokoCanvasImageAreaGtk(_DrawingAreaWidget);
#endif
    _ImageArea->Clear();
}

void TKinokoControlImagePortGtk::Redraw(void)
{
    if (_ImageArea != 0) {
	TKinokoControlImagePort::Redraw();
    }
}

TKinokoCanvasImageArea* TKinokoControlImagePortGtk::GetImageArea(void)
{
    if (_ImageArea == 0) {
	Initialize();
    }

    return _ImageArea;
}
