/* KinokoShellAboutDialogGtk.cc */
/* Created by Enomoto Sanshiro on 9 July 2000. */
/* Last updated by Enomoto Sanshiro on 9 July 2000. */


#include <string>
#include <vector>
#include <gtk/gtk.h>
#include "KinokoShellAboutDialogGtk.hh"

using namespace std;


static const char* TitleFontName = "helvetica normal 18";

static void okbutton_clicked_cb(GtkWidget* Widget, gpointer Data);
static void dialog_destroy_cb(GtkWidget* Widget, gpointer Data);


TKinokoShellAboutDialogGtk::TKinokoShellAboutDialogGtk(void)
{
}

TKinokoShellAboutDialogGtk::~TKinokoShellAboutDialogGtk()
{
}

void TKinokoShellAboutDialogGtk::SetTitle(const char* Title)
{
    _Title = Title;
}

void TKinokoShellAboutDialogGtk::SetCopyright(const char* Copyright)
{
    _Copyright = Copyright;
}

void TKinokoShellAboutDialogGtk::AddAuthor(const char* Author)
{
    _AuthorList.push_back(Author);
}

void TKinokoShellAboutDialogGtk::AddComment(const char* Comment)
{
    _CommentList.push_back(Comment);
}

void TKinokoShellAboutDialogGtk::SetLogoImage(const char* ImageFileName)
{
    _ImageFileName = ImageFileName;
}

void TKinokoShellAboutDialogGtk::Open(void)
{
    GtkWidget* Dialog = gtk_dialog_new();

    GtkWidget* TitleLabel = gtk_label_new(_Title.c_str());
    GtkWidget* CpoyrightLabel = gtk_label_new(_Copyright.c_str());
    GtkWidget* AuthorListBox = gtk_vbox_new(FALSE, 0);
    GtkWidget* ButtonPadding = gtk_label_new("");
    GtkWidget* OkButton = gtk_button_new_with_label("OK");

    PangoFontDescription* FontDescription = (
	pango_font_description_from_string(TitleFontName)
    );
    if (FontDescription != NULL) {
	GtkStyle* Style = gtk_widget_get_style(TitleLabel);
	GtkStyle* NewStyle = gtk_style_copy(Style);
	NewStyle->font_desc = FontDescription;
	gtk_style_set_font(NewStyle, NULL);
	gtk_widget_set_style(TitleLabel, NewStyle);
    }

    gtk_window_set_title(GTK_WINDOW(Dialog), "about...");
    gtk_misc_set_padding(GTK_MISC(TitleLabel), 10, 10);
    GTK_WIDGET_SET_FLAGS(OkButton, GTK_CAN_DEFAULT);

    gtk_box_pack_start(
	GTK_BOX(GTK_DIALOG(Dialog)->vbox), TitleLabel, TRUE, TRUE, 0
    );
    gtk_box_pack_start(
	GTK_BOX(GTK_DIALOG(Dialog)->vbox), CpoyrightLabel, TRUE, TRUE, 0
    );
    gtk_box_pack_start(
	GTK_BOX(GTK_DIALOG(Dialog)->vbox), AuthorListBox, TRUE, TRUE, 10
    );

    gtk_box_pack_start(
	GTK_BOX(GTK_DIALOG(Dialog)->action_area), ButtonPadding, TRUE, TRUE, 5
    );
    gtk_box_pack_start(
	GTK_BOX(GTK_DIALOG(Dialog)->action_area), OkButton, TRUE, TRUE, 5
    );

    if (! _AuthorList.empty()) {
	GtkWidget* AuthorListLabel = gtk_label_new("Authors:");
	gtk_misc_set_padding(GTK_MISC(AuthorListLabel), 5, 0);
	gtk_misc_set_alignment(GTK_MISC(AuthorListLabel), 0.0f, 0.0f);
	gtk_box_pack_start(GTK_BOX(AuthorListBox), AuthorListLabel, TRUE, TRUE, 2);
	for (unsigned i = 0; i < _AuthorList.size(); i++) {
	    GtkWidget* Label = gtk_label_new(_AuthorList[i].c_str());
	    gtk_misc_set_padding(GTK_MISC(Label), 25, 0);
	    gtk_misc_set_alignment(GTK_MISC(Label), 0.0f, 0.0f);
	    gtk_box_pack_start(GTK_BOX(AuthorListBox), Label, TRUE, TRUE, 2);
	}
    }

    gtk_signal_connect(
	GTK_OBJECT(OkButton), "clicked",
	GTK_SIGNAL_FUNC(okbutton_clicked_cb), Dialog
    );
    gtk_signal_connect(
	GTK_OBJECT(Dialog), "destroy",
	GTK_SIGNAL_FUNC(dialog_destroy_cb), 0
    );

    gtk_widget_grab_default(OkButton);
    gtk_widget_show_all(Dialog);    
    gtk_grab_add(Dialog);
}


static void okbutton_clicked_cb(GtkWidget* Widget, gpointer Data)
{
    GtkWidget* Dialog = GTK_WIDGET(Data);
    gtk_widget_destroy(Dialog);
}

static void dialog_destroy_cb(GtkWidget* Widget, gpointer Data)
{
    gtk_grab_remove(GTK_WIDGET(Widget));
}
