/* KinokoShellPopupWindowGtk.cc */
/* Created by Enomoto Sanshiro on 5 Fabruary 2002. */
/* Last updated by Enomoto Sanshiro on 5 Fabruary 2002. */


#include <string>
#include <vector>
#include <map>
#include <gtk/gtk.h>
#include "KinokoShellPopupWindow.hh"
#include "KinokoShellPopupWindowGtk.hh"

using namespace std;

static const char* TypeFontName = "helvetica normal 18";

static void button_clicked_cb(GtkWidget* Widget, gpointer Data);
static void dialog_destroy_cb(GtkWidget* Widget, gpointer Data);


TKinokoShellPopupWindowGtk::TKinokoShellPopupWindowGtk(void)
{
    _DialogWidget = 0;
}

TKinokoShellPopupWindowGtk::~TKinokoShellPopupWindowGtk()
{
}

string TKinokoShellPopupWindowGtk::Open(bool IsModal)
{
    _DialogWidget = gtk_dialog_new();
    gtk_window_set_title(GTK_WINDOW(_DialogWidget), _Type.c_str());
    gtk_window_set_position(GTK_WINDOW(_DialogWidget), GTK_WIN_POS_CENTER);

    GtkWidget* TypeLabel = gtk_label_new(_Type.c_str());

    PangoFontDescription* FontDescription = (
	pango_font_description_from_string(TypeFontName)
    );
    if (FontDescription != NULL) {
	GtkStyle* Style = gtk_widget_get_style(TypeLabel);
	GtkStyle* NewStyle = gtk_style_copy(Style);
	NewStyle->font_desc = FontDescription;
	gtk_style_set_font(NewStyle, NULL);
	gtk_widget_set_style(TypeLabel, NewStyle);
    }

    gtk_misc_set_padding(GTK_MISC(TypeLabel), 10, 5);
    gtk_misc_set_alignment(GTK_MISC(TypeLabel), 0.0f, 0.0f);
    gtk_box_pack_start(
	GTK_BOX(GTK_DIALOG(_DialogWidget)->vbox), TypeLabel, 
	TRUE, TRUE, 0
    );

    GtkWidget* MessageLabel = gtk_label_new(_Message.c_str());
    gtk_misc_set_padding(GTK_MISC(MessageLabel), 20, 10);
    gtk_box_pack_start(
	GTK_BOX(GTK_DIALOG(_DialogWidget)->vbox), MessageLabel, 
	TRUE, TRUE, 0
    );

    GtkWidget* ButtonPadding = gtk_label_new("");
    gtk_box_pack_start(
	GTK_BOX(GTK_DIALOG(_DialogWidget)->action_area), ButtonPadding, 
	TRUE, TRUE, 0
    );

    for (unsigned i = 0; i < _ActionList.size(); i++) {
	const string& ButtonLabel = _ActionList[i];
	GtkWidget* Button = gtk_button_new_with_label(ButtonLabel.c_str());
	_ButtonLabelTable[(long) Button] = ButtonLabel;

	gtk_box_pack_start(
	    GTK_BOX(GTK_DIALOG(_DialogWidget)->action_area), Button, 
	    TRUE, TRUE, 0
	);
	gtk_signal_connect(
	    GTK_OBJECT(Button), "clicked",
	    GTK_SIGNAL_FUNC(button_clicked_cb), this
	);
    }

    gtk_signal_connect(
	GTK_OBJECT(_DialogWidget), "destroy",
	GTK_SIGNAL_FUNC(dialog_destroy_cb), this
    );

    gtk_widget_show_all(_DialogWidget);    

    if (IsModal) {
	gtk_grab_add(_DialogWidget);
	_IsGrabingFocus = true;
    }
    else {
	_IsGrabingFocus = false;
    }

    _SelectedAction = "";
    gtk_main();

    return _SelectedAction;
}

GtkWidget* TKinokoShellPopupWindowGtk::GetDialogWidget(void)
{
    return _DialogWidget;
}

void TKinokoShellPopupWindowGtk::SetSelectedWidget(GtkWidget* Widget)
{
    _SelectedAction = _ButtonLabelTable[(long) Widget];
}

bool TKinokoShellPopupWindowGtk::IsGrabingFocus(void) 
{
    return _IsGrabingFocus;
}

static void button_clicked_cb(GtkWidget* Widget, gpointer Data)
{
    TKinokoShellPopupWindowGtk* PopupWindow = (TKinokoShellPopupWindowGtk*) Data;

    PopupWindow->SetSelectedWidget(Widget);

    gtk_widget_destroy(GTK_WIDGET(PopupWindow->GetDialogWidget()));
}

static void dialog_destroy_cb(GtkWidget* Widget, gpointer Data)
{
    TKinokoShellPopupWindowGtk* PopupWindow = (TKinokoShellPopupWindowGtk*) Data;

    if (PopupWindow->IsGrabingFocus()) {
	gtk_grab_remove(GTK_WIDGET(Widget));
    }

    gtk_main_quit();
}
