/* kinoko-board-gtk.cc */
/* Created by Enomoto Sanshiro on 29 October 2001. */
/* Last updated by Enomoto Sanshiro on 29 October 2001. */


#include <iostream>
#include <string>
#include "MushArgumentList.hh"
#include "KinokoShellConnector.hh"
#include "KinokoBoardGtk.hh"

using namespace std;


static const int DefaultBoardWidth = 540;
static const int DefaultBoardHeight = 340;


int main(int argc, char** argv)
{
    string HostName;
    int PortNumber;
    bool IsClient;
    int BoardWidth, BoardHeight;

    TMushArgumentList ArgumentList(argc, argv);
    try {
	ArgumentList.ExpectParameters(2);
	HostName = ArgumentList.ParameterOf(0);
	PortNumber = ArgumentList.IntParameterOf(1);
	IsClient = ArgumentList.IsOptionSpecified("--client");

	if (ArgumentList.IsOptionSpecified("--width")) {
	    BoardWidth = ArgumentList.IntOptionValueOf("--width");
	}
	else {
	    BoardWidth = DefaultBoardWidth;
	}

	if (ArgumentList.IsOptionSpecified("--height")) {
	    BoardHeight = ArgumentList.IntOptionValueOf("--height");
	}
	else {
	    BoardHeight = DefaultBoardHeight;
	}
    }
    catch (TSystemCallException& e) {
	cerr << "Usage: " << argv[0] << " HOSTNAME PORT_NUMBER" << endl;
	return 0;
    }

    TKinokoShellConnector* ShellConnector;
    if (IsClient) {
	ShellConnector = new TKinokoClientSocketShellConnector(HostName, PortNumber);
    }
    else {
	ShellConnector = new TKinokoSocketShellConnector(HostName, PortNumber);
    }

    int FileDescriptor = ShellConnector->Connect();
    if (FileDescriptor < 0) {
	cerr << "unable to connect to " << HostName << endl;
	return -1;
    }

    TKinokoBoard* Board = new TKinokoBoardGtk(
	ShellConnector, argc, argv, BoardWidth, BoardHeight
    );

    Board->Start();

    delete Board;
    delete ShellConnector;

    return 0;
}
