/* kinoko-canvas-gtk.cc */
/* Created by Enomoto Sanshiro on 9 July 2000. */
/* Last updated by Enomoto Sanshiro on 2 October 2001. */


#include <iostream>
#include <string>
#include "MushArgumentList.hh"
#include "KinokoShellConnector.hh"
#include "KinokoCanvasGtk.hh"

using namespace std;


static const int DefaultWidth = 800;
static const int DefaultHeight = 600;
static const int DefaultTop = -1;
static const int DefaultLeft = -1;

int main(int argc, char** argv)
{
    string HostName;
    int PortNumber = 0;
    bool IsClient, IsEpsEnabled;
    int Width, Height, Left, Top;

    TMushArgumentList ArgumentList(argc, argv);
    try {
	if (ArgumentList.NumberOfParameters() >= 2) {
	    HostName = ArgumentList.ParameterOf(0);
	    PortNumber = ArgumentList.IntParameterOf(1);
	}
	IsClient = ArgumentList.IsOptionSpecified("--client");
	IsEpsEnabled = ArgumentList.IsOptionSpecified("--enable-eps");

	Width = ArgumentList.IntOptionValueOf("--width", DefaultWidth);
	Height = ArgumentList.IntOptionValueOf("--height", DefaultHeight);
	Left = ArgumentList.IntOptionValueOf("--left", DefaultLeft);
	Top = ArgumentList.IntOptionValueOf("--top", DefaultTop);
    }
    catch (TSystemCallException& e) {
	cerr << "Usage: " << argv[0] << " [HOST_NAME PORT_NUMBER] ";
	cerr << "[--width=WIDTH] [--height=HEIGHT] ";
	cerr << "[--left=LEFT --top=TOP] " << endl;
	return 0;
    }

    TKinokoShellConnector* ShellConnector;
    if (HostName.empty()) {
	ShellConnector = new TKinokoConsoleShellConnector();
    }
    else if (IsClient) {
	ShellConnector = new TKinokoClientSocketShellConnector(HostName, PortNumber);
    }
    else {
	ShellConnector = new TKinokoSocketShellConnector(HostName, PortNumber);
    }

    int FileDescriptor = ShellConnector->Connect();
    if (FileDescriptor < 0) {
	cerr << "unable to connect to " << HostName << endl;
	return -1;
    }

    TKinokoCanvas* Canvas = new TKinokoCanvasGtk(
	ShellConnector, argc, argv, 
	Width, Height, Left, Top,
	IsEpsEnabled
    );

    Canvas->Start();

    delete Canvas;
    delete ShellConnector;

    return 0;
}
