/* kinoko-splash-gtk.cc */
/* Created by Enomoto Sanshiro on 11 November 2000. */
/* Last updated by Enomoto Sanshiro on 11 November 2000. */


#include <string>
#include <gtk/gtk.h>
#include <MushArgumentList.hh>

using namespace std;


static gint quit_cb(void*);


int main(int argc, char** argv)
{
    gtk_init(&argc, &argv);
    TMushArgumentList ArgumentList(argc, argv);

    if (ArgumentList.NumberOfParameters() < 1) {
	cerr << "Usage: " << argv[0] << " IMAGE_FILE [--time=TIME_MS]" << endl;
	return 0;
    }

    int Time_ms;
    string FileName = ArgumentList[0];
    try { 
	Time_ms = ArgumentList.IntOptionValueOf("--time");
    }
    catch (TSystemCallException& e) {
	Time_ms = 3000;
    }

    GtkWidget* Image = gtk_image_new_from_file(FileName.c_str());
    GtkWidget* Window = gtk_window_new(GTK_WINDOW_POPUP);
    gtk_window_set_position(GTK_WINDOW(Window), GTK_WIN_POS_CENTER);
    gtk_container_add(GTK_CONTAINER(Window), Image);
    gtk_widget_show_all(Window);

    gtk_timeout_add(Time_ms, quit_cb, 0);
    gtk_main();

    return 0;
}

static gint quit_cb(void*)
{
    gtk_main_quit();

    return 0;
}
