<html>

<head>
<title>Web-Kinoko Run Index</title>
<style type="text/css">
  #left_panel {
     float: left;
     width: 250px;
     margin-right: 20px;
     margin-bottom: 20px;
  }
  #right_panel {
     float: left;
     width: 640px;
     margin-top: -3px;
     margin-left: 0px;
     margin-right: 20px;
     margin-bottom: 20px;
  }
  #current_run {
     padding-top: 0px;
     padding-left: 10px;
     padding-bottom: 20px;
     margin-bottom: 10px;
     border: thin dotted black;
  }
  #search {
     padding-top: 10px;
     padding-bottom: 5px;
     padding-left: 10px;
     background: #eeeeee;
  }
  #runlist {
  }
</style>
</head>

<?php
$month_name_list = array(
    '', 
    'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 
    'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'
);
function month_name($month) {
    global $month_name_list;
    return $month_name_list[(int)$month];
}
date_default_timezone_set('UTC');
?>

<?php
if (isset($_GET['search'])) {
    if ($_GET['search'] == 'Select') {
	$start_year = $_GET['start_year'];
	$start_month = $_GET['start_month'];
	$start_day = $_GET['start_day'];
	$end_year = $_GET['end_year'];
	$end_month = $_GET['end_month'];
	$end_day = $_GET['end_day'];
	$filename_pattern = $_GET['filename_pattern'];
	$comment_pattern = $_GET['comment_pattern'];
    }
    else {
	$start_year = '';
	$start_month = '';
	$start_day = '';
	$end_year = '';
	$end_month = '';
	$end_day = '';
	$filename_pattern = '';
	$comment_pattern = '';
    }
    setcookie('start_year', $start_year);
    setcookie('start_month', $start_month);
    setcookie('start_day', $start_day);
    setcookie('end_year', $end_year);
    setcookie('end_month', $end_month);
    setcookie('end_day', $end_day);
    setcookie('filename_pattern', $filename_pattern);
    setcookie('comment_pattern', $comment_pattern);
}
else {
    $start_year = (
	(isset($_COOKIE['start_year'])) ? $_COOKIE['start_year'] : ''
    );
    $start_month = (
	(isset($_COOKIE['start_month'])) ? $_COOKIE['start_month'] : ''
    );
    $start_day = (
	(isset($_COOKIE['start_day'])) ? $_COOKIE['start_day'] : ''
    );
    $end_year = (
	(isset($_COOKIE['end_year'])) ? $_COOKIE['end_year'] : ''
    );
    $end_month = (
	(isset($_COOKIE['end_month'])) ? $_COOKIE['end_month'] : ''
    );
    $end_day = (
	(isset($_COOKIE['end_day'])) ? $_COOKIE['end_day'] : ''
    );
    $filename_pattern = (
	(isset($_COOKIE['filename_pattern'])) ? $_COOKIE['filename_pattern'] : ''
    );
    $comment_pattern = (
	(isset($_COOKIE['comment_pattern'])) ? $_COOKIE['comment_pattern'] : ''
    );
}


$start_date = (int) sprintf(
    "%04d%02d%02d", $start_year, $start_month, $start_day
);
$end_date = (int) sprintf(
    "%04d%02d%02d", 
    ($end_year == 0) ? (int)date('Y') + 1 : $end_year,
    ($end_month == 0) ? 12 : $end_month,
    ($end_day == 0) ? 31 : $end_day
);

?>


<body onload="init()">

<h2><font color="green">Web-Kinoko Run Index</font></h2>

<div align="right"><font color="brown"><b>KiNOKO</b></font></div>
<hr>

<div id="left_panel">
<?php
$dir_list = scandir('.', 1);
foreach ($dir_list as $dir) {
    $registry_file = "$dir/kinoko-registry.xml";
    if (! file_exists($registry_file)) {
	continue;
    }
    $registry = simplexml_load_file($registry_file);
    $is_running = ($registry->kcom->state == "running");

    if ($is_running) {
	echo '<div id="current_run">';
	echo '<font color="red">Currently Running</font>:<br> ';
	echo '<a href="', $dir, '">', $dir, "</a>";
	echo "</div>\n";
    }
    break;
}
?>


<div id="search">
<form action="<?php echo $_SERVER['PHP_SELF'] ?>" method="GET">
  <table>
  <tr><td>From: </td>
  <td><?php 
    echo '<select name="start_year">', "\n";
    echo '<option value="0">Any</option>', "\n";
    for ($year=2008;$year<=(int)date('Y');$year++) {
	echo "<option", ($year == $start_year) ? " selected>" : ">";
	echo $year, "</option>\n";
    }
    echo "</select>\n";

    echo '<select name="start_month">', "\n";
    echo '<option value="0">Any</option>', "\n";
    for ($month=1;$month<=12;$month++) {
	echo '<option value="', $month, '"';
	echo ($month == $start_month) ? " selected>" : ">";
	echo month_name($month), "</option>\n";
    }
    echo "</select>\n";

    echo '<select name="start_day">', "\n";
    echo '<option value="0">Any</option>', "\n";
    for ($day=1;$day<=31;$day++) {
	echo "<option", ($day == $start_day) ? " selected>" : ">";
	echo $day, "</option>\n";
    }
    echo "</select>\n";
  ?></td></tr>

  <tr><td>To: </td>
  <td><?php 
    echo '<select name="end_year">', "\n";
    echo '<option value="0">Any</option>', "\n";
    for ($year=2008;$year<=(int)date('Y');$year++) {
	echo "<option", ($year == $end_year) ? " selected>" : ">";
	echo $year, "</option>\n";
    }
    echo "</select>\n";

    echo '<select name="end_month">', "\n";
    echo '<option value="0">Any</option>', "\n";
    for ($month=1;$month<=12;$month++) {
	echo '<option value="', $month, '"';
	echo ($month == $end_month) ? " selected>" : ">";
	echo month_name($month), "</option>\n";
    }
    echo "</select>\n";

    echo '<select name="end_day">', "\n";
    echo '<option value="0">Any</option>', "\n";
    for ($day=1;$day<=31;$day++) {
	echo "<option", ($day == $end_day) ? " selected>" : ">";
	echo $day, "</option>\n";
    }
    echo "</select>\n";
  ?></td></tr>
  </table>
  <p>
  <?php
    $regex_help = "http://en.wikipedia.org/wiki/Regular_expression";

    echo 'File Name Pattern (<a href="', $regex_help, '">RegEx</a>): ';
    echo '<input type="text" name="filename_pattern" size="24" ';
    echo 'value="', htmlentities($filename_pattern), '">', "<p>\n";

    echo 'Comment Pattern (<a href="', $regex_help, '">RegEx</a>): ';
    echo '<input type="text" name="comment_pattern" size="24" ';
    echo 'value="', htmlentities($comment_pattern), '">', "<p>\n";
  ?>
  <input type="submit" name="search" value="Select">
  <input type="submit" name="search" value="Reset">
</form>
</div>
</div>


<div id="right_panel">
<table id="runlist" cellpadding="3">
<tr bgcolor="#dddddd">
<th>Date</th><th width="100">Length</th><th width="200">Data File</th><th width="300">Comment</th>
</tr>
<?php
foreach ($dir_list as $dir) {
    $registry_file = "$dir/kinoko-registry.xml";
    $report_file = "$dir/kinoko-report.xml";
    if (! file_exists($registry_file) || ! file_exists($report_file)) {
	continue;
    }

    $registry = simplexml_load_file($registry_file);
    $report = simplexml_load_file($report_file);

    if (ereg(
	'([0-9]{4})-([0-9]{2})([0-9]{2})-([0-9]{2})([0-9]{2})',
	$dir, $date_match
    )){
	$year = $date_match[1];
	$month = $date_match[2];
	$day = $date_match[3];
	$hour = $date_match[4];
	$minute = $date_match[5];
    }
    if (! isset($minute)) {
	continue;
    }
    $name = month_name($month) . " $day  $hour:$minute";

    $date = (int) sprintf("%04d%02d%02d", $year, $month, $day);
    if (($date < $start_date) || ($date > $end_date)) {
	continue;
    }

    $filename = $report->{'data-file'};
    if ($filename_pattern != '') {
	if (! ereg($filename_pattern, $filename)) {
	    continue;
	}
    }

    $comment = $report->comment;
    if ($comment_pattern != '') {
	if (! ereg($comment_pattern, $comment)) {
	    continue;
	}
    }

    $running_time = (int) $report->{'running-time'};
    $length_hour = (int) floor($running_time / 3600);
    $length_min = (int) floor(($running_time - 3600*$length_hour) / 60);
    if ($running_time == 0) {
	$length = '-';
    }
    elseif ($running_time < 180) {
	$length = $running_time . ' s';
    }
    else {
	$length = sprintf('%02d:%02d', $length_hour, $length_min);
    }

    $path = urlencode($dir);

    echo '<tr>';
    echo '<td align="center" nowrap><a href="', $path, '">', $name, "</a></td>";
    echo '<td align="center" nowrap>', $length, '</td>';
    echo '<td>', htmlentities($filename), '</td>';
    echo '<td>', htmlentities($comment), '</td>';
    echo "</tr>\n";
}
?>
</table>
</div>

</body>
</html>
