#! /usr/bin/perl -wT
#! /usr/bin/perl -wT

use strict;

my $form_data;
read(STDIN, $form_data, $ENV{'CONTENT_LENGTH'});

my $date = localtime();
my $remote_address = $ENV{'REMOTE_ADDR'};
my $http_referer = $ENV{'HTTP_REFERER'};
my $http_user_agent = $ENV{'HTTP_USER_AGENT'};

print <<EOF;
Content-type: text/html

<html>
<head>
  <meta http-equiv="Content-type" content="text/html; charset=EUC-JP">
  <meta http-equiv="refresh" CONTENT="0;URL=$http_referer">
</head>
</html>
EOF

##################################

my $button_name = "";
my @name_list;
my %value_table;

my @value_list = split(/&/, $form_data);
foreach my $item (@value_list) {
    my ($name, $value) = split(/=/, $item);
    $value =~ tr/+/ /;
    $value =~ s/%([A-Fa-f0-9][A-Fa-f0-9])/pack("C", hex($1))/eg;
    $name =~ s/%([A-Fa-f0-9][A-Fa-f0-9])/pack("C", hex($1))/eg;

    if ($name =~ m/entry:(.+)/) {
	$name = $1;
    }
    elsif ($name =~ m/check:(.+)/) {
	$name = $1;
	if ($value eq "on") {
	    $value = "1";
	}
	else {
	    $value = "0";
	}
    }
    elsif ($name =~ m/radio:(.+)/) {
	$name = $1;
    }
    elsif ($name =~ m/button:([^;]+);on_click/) {
	$button_name = $1;
	next;
    }
    elsif ($name =~ m/on_click:(.+)/) {
	$button_name = $1;
	next;
    }
    else {
	next;
    }

    unless (exists($value_table{$name})) {
	push(@name_list, $name);
    }
    $value_table{$name} = $value;
}

##############################

my $kcml_name = "unknown";
if ($http_referer =~ m/\/([^\/\.]+)\.kcml/) {
    $kcml_name = $1;
}

chdir("command");

open(FILE, "> control/upload-this.kcv.tmp");

print FILE "<?xml version=\"1.0\"?>\n";
print FILE "\n";
print FILE "<!--\n";
print FILE "  <date>$date</date>\n";
print FILE "  <remote_address>$remote_address</remote_address>\n";
print FILE "  <referer>$http_referer</referer>\n";
print FILE "  <user_agent>$http_user_agent</user_agent>\n";
print FILE "-->\n";
print FILE "\n\n";

#print FILE "<!--\n";
#foreach (sort(keys(%ENV))) {
#   print FILE "  <$_>$ENV{$_}<$_>\n";
#}
#print FILE "-->\n";
#print FILE "\n\n";

print FILE "<kcml-widget-values>\n";
foreach my $name (@name_list) {
    my $value = $value_table{$name};
    $value =~ s/&/&amp;/g;
    $value =~ s/</&lt;/g;
    $value =~ s/>/&gt;/g;
    $value =~ s/\"/&quot;/g;
    $value =~ s/\'/&apos;/g;

    print FILE "  <widget name=\"$name\">$value</widget>\n";
}
print FILE "\n";
print FILE "  <operation type=\"click\" target=\"$button_name\"/>\n";
print FILE "</kcml-widget-values>\n";

close(FILE);

rename("control/upload-this.kcv.tmp", "control/upload-this.kcv.ready"); 
