#! /usr/bin/perl
# genscript-kinoko-trend.pl
# Created by Sanshiro Enomoto on 21 February 2008.


($script_file, $data_file, $value_min, $value_max, $interval, $length, $channel_list, $target) = @ARGV;
($value_max ne "") or die "Usage: genscript-kinoko-trend SCRIPT_FILE DATA_FILE VALUE_MIN VALUE_MAX [INTERVAL LENGTH [CHANNEL_LIST [TARGET]]]\n";

($interval ne "") or $interval = "1";
($length ne "") or $length = "60";


@data_path_list = split(/\//, $data_file);
$data_file_name = @data_path_list[$#data_path_list];

@script_path_list = split(/\//, $script_file);
$script_file_name = @script_path_list[$#script_path_list];
($data_name = $script_file_name) =~ s/\.\w+$//;

foreach $channel (split(/,/, $channel_list)) {
    $channel_flags{$channel} = "1";
}


open(DATA_FILE, $data_file) or die "unable to open $data_file\n";
while (<DATA_FILE>) {
    chop($_);
    if (/^#\s*Fields\s*:\s*(.*)/) {
	@field_list = split(/\s+/, $1);
	last;
    }
}

close(DATA_FILE);

($script = <<EOF)
    :// $script_file
    :// KinokoViewer script for '$data_file_name'.
    :// Generated automatically from $data_file by 'genscript-kinoko-trend'.
    :
    :display $data_name
    :{
    :    %CREATE_TREND%
    :
    :    analysis {
    :        %DECLARE_FIELDS%
    :
    :        %FILL_TREND%
    :    }
    :
    :    on every (1 sec) {
    :        %DRAW_TREND%
    :    }
    :}
EOF
    =~ s/[ \t]*://sg;

$create_trend = "";
$declare_fields = "";
$fill_trend = "";
$draw_trend = "";
$indent = "    ";

$index = 0;
foreach $field_name (@field_list) {
    if (($field_name eq "index") or ($field_name eq "time")) {
        next;
    }

    $field_name =~ /([^\.]+)\.([^\.]+)/;
    $section_name = $1;
    $channel_name = $2;

    if (($channel_list ne "") and ($channel_flags{$channel_name} ne "1")) {
	next;
    }

    $create_trend .= (
        "$indent" .
	"Trend trend_$index(\"$field_name\", $value_min, $value_max, $length, $interval);\n"
    );
    $declare_fields .= (
        "$indent" . "$indent" .
        "DataElement data_$index(\"$section_name\", $channel_name);\n"
    );
    $fill_trend .= "$indent" . "$indent" . "trend_$index.fill(data_$index);\n";

    if ($target eq "counts") {
	$draw_trend .= "$indent" . "$indent" . "trend_$index.drawCounts();\n";
    }
    else {
	$draw_trend .= "$indent" . "$indent" . "trend_$index.drawMean();\n";
    }

    $index++;
}

$script =~ s/[ \t]*%CREATE_TREND%[ \t]*\n/$create_trend/;
$script =~ s/[ \t]*%DECLARE_FIELDS%[ \t]*\n/$declare_fields/;
$script =~ s/[ \t]*%FILL_TREND%[ \t]*\n/$fill_trend/;
$script =~ s/[ \t]*%DRAW_TREND%[ \t]*\n/$draw_trend/;

open(SCRIPT_FILE, "> $script_file") or die "unable to create $script_file.";
print SCRIPT_FILE $script;
close SCRIPT_FILE;
