#! /usr/bin/perl
# genscript-root-plot.pl
# Created by Sanshiro Enomoto on 23 June 2000.
# Last updated by Sanshiro Enomoto on 7 May 2001.


($script_file, $data_file, $min, $max, $interval, $length, $channel_list) = @ARGV;
($data_file ne "") or die "Usage: genscript-root-plot SCRIPT_FILE DATA_FILE [ MIN MAX INTERVAL LENGTH CHANNEL_LIST ]\n";


@data_path_list = split(/\//, $data_file);
$data_file_name = @data_path_list[$#data_path_list];

@script_path_list = split(/\//, $script_file);
$script_file_name = @script_path_list[$#script_path_list];
($data_name = $script_file_name) =~ s/\.\w+$//;

foreach $channel (split(/,/, $channel_list)) {
    $channel_flags{$channel} = "1";
}


open (DATA_FILE, $data_file) or die "unable to open $data_file\n";
while (<DATA_FILE>) {
    chop($_);
    if (/^#\s*Fields\s*:\s*(.*)/) {
	@field_list = split(/\s+/, $1);
	last;
    }
}
close DATA_FILE;


($script = <<EOF)
    :// $script_file
    :// ROOT script for '$data_file_name'.
    :// Generated automatically from $data_file by 'genscript-root-plot'.
    :
    :
    :#include <strstream.h>
    :#include <fstream.h>
    :
    :
    :int $data_name()
    :{
    :    gROOT->Reset();
    :    gROOT->SetStyle("Plain");
    :    TFile* file = new TFile("$data_name.root", "RECREATE");
    :
    :    ifstream is("$data_file");
    :    if (! is) {
    :        cerr << "ERROR: unable to open file: $data_file" << endl;
    :        return -1;
    :    }
    :
    :    TCanvas* canvas = new TCanvas("canvas", "canvas", 0, 0, 800, 600);
    :    %CREATE_NTUPLE%
    :
    :    char buffer[256];
    :    float index, data[%NUMBER_OF_FIELDS%];
    :    while (is.getline(buffer, sizeof(buffer), '\\n')) {
    :        if (buffer[0] == '#') {
    :            continue;
    :        }
    :
    :        if (%READ_DATA%) {
    :            ntuple->Fill(data);
    :        }
    :    }
    :
    :    canvas->Divide(%ROWS%, %COLS%);
    :    %DRAW_GRAPH%
    :
    :    file->Write();
    :    canvas->Print("$data_name.ps");
    :
    :    return 0;
    :}
EOF
    =~ s/[ \t]*://sg;

$number_of_fields = @field_list;
$create_ntuple = "    TNtuple* ntuple = new TNtuple(\"ntuple\", \"ntuple\", \"Index\");\n";
$read_data = "istrstream(buffer) >> index >> data[0]";

$index = 0;
foreach $field_name (@field_list) {
    if (($field_name eq "index") or ($field_name eq "time")) {
        next;
    }

    $field_name =~ /([^\.]+)\.([^\.]+)/;
    $channel_name = $2;
    if (($channel_list ne "") and ($channel_flags{$channel_name} ne "1")) {
	next;
    }

    $index++;

    $create_ntuple =~ s/\"\)/:$field_name\"\)/;
    $read_data .= " >> data[$index]";
    $draw_graph .= "    canvas->cd($index);\n";
    $draw_graph .= "    ntuple->Draw(\"$field_name:Index\");\n";
    $draw_graph .= "    TGraph *Graph$index = new TGraph(ntuple->GetSelectedRows(), ntuple->GetV2(), ntuple->GetV1());\n";
    $draw_graph .= "    Graph$index->Draw(\"l\");\n\n";
}

$script =~ s/[ \t]*%CREATE_NTUPLE%[ \t]*\n/$create_ntuple/;
$script =~ s/%NUMBER_OF_FIELDS%/$number_of_fields/;
$script =~ s/%READ_DATA%/$read_data/;
$script =~ s/[ \t]*%CREATE_GRAPH%[ \t]*\n/$create_graph/;
$script =~ s/[ \t]*%DRAW_GRAPH%[ \t]*\n/$draw_graph/;

if ($index <= 12) {
    $rows = (1, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4)[$index - 1];
    $cols = (1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3)[$index - 1];
}
else {
    $rows = int sqrt($index - 1) + 1;
    $cols = ($index - 1) / $rows + 1;
}
$script =~ s/%ROWS%/$rows/;
$script =~ s/%COLS%/$cols/;

open(SCRIPT_FILE, "> $script_file") or die "unable to create $script_file.";
print SCRIPT_FILE $script;
close SCRIPT_FILE;


