/* kdump.c */

#include <stdio.h>
#include <string.h>
#include <ctype.h>


void Dump(FILE* File, unsigned long Offset, int WordSize) 
{
    unsigned long Byte;
    unsigned long Word = 0;
    int ByteCounts = 0;
    unsigned long Address = Offset;
    char TextString[32] = "";
    char FormatString[32] = "%02x ";

    TextString[16] = '\0';
    FormatString[2] = '0' + (2*WordSize);

    while ((Byte = getc(File)) != EOF) {
	if (Address % 16 == 0) {
	    printf("%04lx %04lx:  ", Address >> 16, Address & 0x0000ffff);
	}
	else if (Address % 8 == 0) {
	    printf("  ");
	}

	Word = Word | (Byte << (8*ByteCounts));
	TextString[Address % 16] = isprint(Byte) ? Byte : '.';

	Address++;
	ByteCounts++;

	if (ByteCounts % WordSize == 0) {
	    printf(FormatString, Word);
	    Word = 0;
	    ByteCounts = 0;
	}

	if (Address % 16 == 0) {
	    printf("  %s\n", TextString);
	}
    }

    putchar('\n');
}


int main(int argc, char** argv)
{
    char* FileName = NULL;
    FILE* File = NULL;
    unsigned long Offset = 0;
    int WordSize;

    if ((argc > 1) && (strcmp(argv[1], "--help") == 0)) {
	printf("usage: %s [FileName [Offset(hex)]]\n", argv[0]);
	return 0;
    }

    if (argc > 1) {
	FileName = argv[1];
	if ((File = fopen(FileName, "r")) == NULL) {
	    fprintf(stderr, "unable to open file: %s\n", FileName);
	    return -1;
	}

	if (argc > 2) {
	    if (sscanf(argv[2], "%lx", &Offset) != 1) {
		fprintf(stderr, "bad file offset: %s\n", argv[2]);
		fclose(File);
		return -1;
	    }

	    Offset &= ~0x000fUL;

	    if (fseek(File, Offset, SEEK_SET) < 0) {
		fprintf(stderr, "invalid file offset: %s\n", argv[2]);
		fclose(File);
		return -1;
	    }
	}
    }
    else {
	File = stdin;
    }

    if (strstr(argv[0], "kdump16") != NULL) {
	WordSize = 2;
    }
    else if (strstr(argv[0], "kdump32") != NULL) {
	WordSize = 4;
    }
    else {
	WordSize = 1;
    }

    Dump(File, Offset, WordSize);

    if (FileName != NULL) {
	fclose(File);
    }

    return 0;
}
