/* VmeTdc.kts */
/* Created by Enomoto Sanshiro on 27 April 2005 */
/* Last updated by Enomoto Sanshiro on 27 April 2005 */


datasource VmeTdc
{
    int base_address = 0x07750000;
    int readout_channels = #0..#3 | #16;

    VmeCrate crate;
    VmeController controller("SBS-620");
    VmeModule tdc("CAEN-V775N");
    
    crate.installController(controller);
    crate.installModule(tdc, base_address);

    on run_begin {
        //tdc.selectCommonStopMode();

	tdc.disable(~readout_channels);
        tdc.disableZeroSuppression();
	tdc.disableOverflowSuppression();
	tdc.disableNotValidDataSuppression();

	//tdc.setThreshold(0, 1000);
	//tdc.setEventTrigger(16);
    };

    Register event_counter;
    DataRecord event_info;

    on trigger(tdc) {
        tdc.read(readout_channels);
	//tdc.blockRead();

        tdc.readEventCounter(event_counter);
	event_info.fill("event_count", event_counter);
	event_info.send();
    }
}
