/* CamacAdcTdcTester.kts */
/* Created by Enomoto Sanshiro on 5 December 2005 */
/* Last updated by Enomoto Sanshiro on 9 December 2005 */


datasource CamacAdcTester {
    int tester_station = 22;
    int adc_station = 17;
    int adc_channel = #0;

    ChannelList tester_channels;
    tester_channels.add(0, "amplitude");
    tester_channels.add(1, "full_scale");
    tester_channels.add(2, "gate_width");
    tester_channels.add(3, "tail_fall_time");

    CamacCrate crate;
    CamacController controller("Toyo-CC7x00");
    CamacModule tester("LeCroy-1976");
    CamacModule adc("Generic-Standard");

    crate.installController(controller);
    crate.installModule(tester, tester_station);
    crate.installModule(adc, adc_station);

    SoftwareModule timer("IntervalTimer");
    Register amplitude;

    on run_begin {
	tester.selectChargeMode();
	tester.setChargeFullScale(600);
	tester.setGateWidth(200);
	tester.selectFastTail();

	amplitude.load(0);
	timer.setInterval(0, 10000);
    }

    on trigger (timer) {
	amplitude.add(0x10);
	when (amplitude > 0xffff) {
	    //terminate;
	    amplitude.load(0x10);
	}
	tester.setAmplitude(amplitude);
	tester.execute();
    }

    on trigger (adc) {
	adc.read(adc_channel);
	adc.clear();

        // read test pulse setting
	tester.tagRead(tester_channels);  
    }
}


datasource CamacTdcTester {
    int tester_station = 22;
    int tdc_station = 15;
    int tdc_channel = #0;

    ChannelList tester_channels;
    tester_channels.add(0, "amplitude");
    tester_channels.add(1, "full_scale");

    CamacCrate crate;
    CamacController controller("Toyo-CC7x00");
    CamacModule tester("LeCroy-1976");
    CamacModule tdc("Generic-Standard");

    crate.installController(controller);
    crate.installModule(tester, tester_station);
    crate.installModule(tdc, tdc_station);

    SoftwareModule timer("IntervalTimer");
    Register amplitude;

    on run_begin {
	tester.selectTimeMode();
	tester.setTimeFullScale(4800);
	tester.selectShortPulse();

	amplitude.load(0);
	timer.setInterval(0, 10000);
    }

    on trigger (timer) {
	amplitude.add(0x10);
	when (amplitude > 0xffff) {
	    //terminate;
            amplitude.load(0x10);
	}

	tester.setAmplitude(amplitude);
	tester.execute();
    }

    on trigger (tdc) {
	tdc.read(tdc_channel);
	tdc.clear();

        // read test pulse setting
	tester.tagRead(tester_channels);  
    }
}
