/* CamacScaler.kts */
/* Created by Enomoto Sanshiro on 30 May 2008. */
/* Last updated by Enomoto Sanshiro on 30 May 2008. */

datasource CamacScaler
{
    int station_number = 10;
    int readout_channels = #0..#3;
    
    CamacCrate crate;
    CamacController controller("Toyo-CC7x00");
    CamacModule scaler("Generic-Standard");
    SoftwareModule timer("IntervalTimer");
    
    crate.installController(controller);
    crate.installModule(scaler, station_number);

    on run_begin {
	timer.setInterval(1, 0);
    }

    on trigger(timer) {
	scaler.read(readout_channels);
    }
}

