/* CamacTdcTester.kts */
/* Created by Enomoto Sanshiro on 18 January 2004. */
/* Last updated by Enomoto Sanshiro on 18 January 2004. */


datasource CamacTdcTester
{
    CamacCrate crate;
    CamacController controller("Toyo-CC7x00");
    CamacModule tdc_tester("Generic-Standard");
    SoftwareModule timer("IntervalTimer");
    
    int station_number;
    crate.installController(controller);
    crate.installModule(tdc_tester, station_number = 6);
    
    Register data;
    on run_begin { 
	int sec, usec;
        timer.setInterval(sec = 0, usec = 10000);
        data.load(0);
    }

    on trigger(timer) {
        data.add(0x100);
        when (data >= 0x10000) {
      	    data.load(0);
	}

	int address, function;
	tdc_tester.transact(function=16, address=0, data);
	tdc_tester.transact(function=26, address=0);
    }
}
